/*
 * Decompiled with CFR 0.152.
 */
package soot.brewing;

import net.minecraft.nbt.NBTTagCompound;
import soot.brewing.EssenceType;

public class EssenceStack {
    public static final EssenceStack EMPTY = new EssenceStack(null, 0);
    private EssenceType essence;
    private int amount;

    public EssenceStack(EssenceType essence, int amount) {
        this.essence = essence;
        this.amount = amount;
    }

    public EssenceStack(NBTTagCompound compound) {
        this.readFromNBT(compound);
    }

    public EssenceType getEssence() {
        return this.essence;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public void add(EssenceStack other) {
        this.amount += other.amount;
    }

    public void remove(EssenceStack other) {
        this.amount = Math.max(0, this.amount - other.amount);
    }

    public boolean isEmpty() {
        return this.essence == null || this.amount <= 0;
    }

    private void readFromNBT(NBTTagCompound nbt) {
        this.essence = EssenceType.getType(nbt.func_74779_i("type"));
        this.amount = nbt.func_74762_e("amount");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("type", this.essence.getName());
        nbt.func_74768_a("amount", this.amount);
        return nbt;
    }
}

