/*
 * Decompiled with CFR 0.152.
 */
package soot.brewing;

import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import soot.util.MiscUtil;
import teamroots.embers.EventManager;

public class EssenceType
implements Comparable<EssenceType> {
    public static Map<String, EssenceType> TYPES = new HashMap<String, EssenceType>();
    public static final EssenceType NULL = new EssenceType("null", Color.WHITE, new Color(1, 1, 1, 0));
    public static final EssenceType FIRE = new EssenceType("fire"){

        @Override
        public Color getFillColor() {
            float sine = 0.5f * ((float)Math.sin(Math.toRadians(4.0f * EssenceType.getTicks())) + 1.0f);
            return new Color(128, 32 + (int)(64.0f * sine), 8);
        }

        @Override
        public Color getOverlayColor() {
            return new Color(255, 128, 16);
        }
    };
    public static final EssenceType ICE = new EssenceType("ice", new Color(192, 240, 255, 255), new Color(255, 255, 255, 255));
    public static final EssenceType TOXIN = new EssenceType("toxin", new Color(120, 0, 240, 255), new Color(180, 0, 255, 255));
    public static final EssenceType VILE = new EssenceType("vile", new Color(128, 32, 0, 255), new Color(192, 48, 0, 255));
    public static final EssenceType DEATH = new EssenceType("death", new Color(64, 64, 64, 255), new Color(0, 0, 0, 0));
    public static final EssenceType SOUR = new EssenceType("sour", new Color(128, 255, 64, 255), new Color(0, 0, 0, 0));
    public static final EssenceType SWEET = new EssenceType("sweet", new Color(255, 128, 255, 255), new Color(255, 255, 255, 255));
    public static final EssenceType CLOUD = new EssenceType("cloud", new Color(0, 64, 64, 255), new Color(128, 128, 255, 255));
    public static final EssenceType LIFEDRINKER = new EssenceType("lifedrinker", new Color(128, 32, 0, 255), new Color(0, 0, 0, 0));
    public static final EssenceType SLOWNESS = new EssenceType("slowness", new Color(192, 192, 255, 255), new Color(0, 0, 0, 0));
    public static final EssenceType SPEED = new EssenceType("speed", new Color(128, 128, 255, 255), new Color(255, 255, 255, 255));
    public static final EssenceType INVERSION = new EssenceType("inversion"){

        @Override
        public Color getFillColor() {
            float sine = 0.5f * ((float)Math.sin(Math.toRadians(4.0f * EssenceType.getTicks())) + 1.0f);
            return MiscUtil.lerpColor(new Color(255, 0, 255, 255), new Color(0, 0, 0, 255), sine);
        }

        @Override
        public Color getOverlayColor() {
            float sine = 0.5f * ((float)Math.sin(Math.toRadians(4.0f * EssenceType.getTicks())) + 1.0f);
            return MiscUtil.lerpColor(new Color(255, 0, 255, 255), new Color(0, 0, 0, 255), 1.0f - sine);
        }
    };
    public static final EssenceType POISON = new EssenceType("poison", new Color(128, 255, 0, 255), new Color(64, 128, 0, 255));
    public static final EssenceType REGENERATION = new EssenceType("regeneration", new Color(255, 128, 255, 255), new Color(0, 0, 0, 0));
    public static final EssenceType WITHER = new EssenceType("wither", new Color(0, 0, 0, 255), new Color(64, 64, 64, 255));
    public static final EssenceType EXPERIENCE = new EssenceType("experience", new Color(128, 255, 0, 255), new Color(255, 255, 0, 255));
    public static final EssenceType HASTE = new EssenceType("haste", new Color(192, 128, 0, 255), new Color(255, 200, 96, 255));
    public static final EssenceType CHAOS = new EssenceType("chaos"){

        @Override
        public Color getFillColor() {
            return Color.getHSBColor(EssenceType.getTicks() * 0.05f, 1.0f, 1.0f);
        }

        @Override
        public Color getOverlayColor() {
            return Color.getHSBColor(EssenceType.getTicks() * 0.05f + 0.33f, 1.0f, 1.0f);
        }
    };
    public static final EssenceType PROJECTILE = new EssenceType("projectile", new Color(255, 255, 255, 255), new Color(0, 0, 0, 255));
    public static final EssenceType GLASS = new EssenceType("glass", new Color(255, 255, 255, 255), new Color(0, 0, 0, 0));
    private String name;
    private Color fillColor;
    private Color overlayColor;

    @SideOnly(value=Side.CLIENT)
    private static float getTicks() {
        return (float)EventManager.ticks + Minecraft.func_71410_x().func_184121_ak();
    }

    public static EssenceType getType(String name) {
        return TYPES.getOrDefault(name, NULL);
    }

    public static Collection<EssenceType> getAllTypes() {
        return TYPES.values().stream().sorted().collect(Collectors.toList());
    }

    public EssenceType(String name) {
        this.name = name;
        TYPES.put(name, this);
    }

    public EssenceType(String name, Color fillColor, Color overlayColor) {
        this(name);
        this.fillColor = fillColor;
        this.overlayColor = overlayColor;
    }

    public String getName() {
        return this.name;
    }

    @SideOnly(value=Side.CLIENT)
    public Color getFillColor() {
        return this.fillColor;
    }

    @SideOnly(value=Side.CLIENT)
    public Color getOverlayColor() {
        return MiscUtil.lerpColor(this.fillColor, this.overlayColor, (double)this.overlayColor.getAlpha() / (double)this.fillColor.getAlpha());
    }

    @Override
    public int compareTo(@Nonnull EssenceType other) {
        return this.name.compareTo(other.name);
    }
}

