/*
 * Decompiled with CFR 0.152.
 */
package soot.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraftforge.fluids.FluidStack;
import soot.recipe.CraftingRegistry;
import soot.recipe.RecipeAlchemicalMixer;
import stanhebben.zenscript.annotations.NotNull;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.value.IntRange;
import teamroots.embers.api.alchemy.AspectList;

@ZenRegister
@ZenClass(value="mods.soot.AlchemicalMixer")
public class AlchemicalMixer {
    public static final String NAME = "Alchemical Mixer";
    public static final String CLASS = "mods.soot.AlchemicalMixer";

    private static AspectList.AspectRangeList toAspectRange(IntRange iron, IntRange copper, IntRange lead, IntRange silver, IntRange dawnstone) {
        AspectList min = AspectList.createStandard((int)iron.getFrom(), (int)dawnstone.getFrom(), (int)copper.getFrom(), (int)silver.getFrom(), (int)lead.getFrom());
        AspectList max = AspectList.createStandard((int)iron.getTo(), (int)dawnstone.getTo(), (int)copper.getTo(), (int)silver.getTo(), (int)lead.getTo());
        return new AspectList.AspectRangeList(min, max);
    }

    @ZenMethod
    public static void add(ILiquidStack output, @NotNull ILiquidStack[] inputs, IntRange iron, IntRange copper, IntRange lead, IntRange silver, IntRange dawnstone) {
        AlchemicalMixer.addInternal(output, inputs, AlchemicalMixer.toAspectRange(iron, copper, lead, silver, dawnstone));
    }

    @ZenMethod
    public static void add(ILiquidStack output, @NotNull ILiquidStack[] inputs, Map<String, IntRange> aspects) {
        AspectList minAspects = new AspectList();
        AspectList maxAspects = new AspectList();
        for (Map.Entry<String, IntRange> entry : aspects.entrySet()) {
            String aspect = entry.getKey();
            minAspects.addAspect(aspect, entry.getValue().getFrom());
            maxAspects.addAspect(aspect, entry.getValue().getTo());
        }
        AlchemicalMixer.addInternal(output, inputs, new AspectList.AspectRangeList(minAspects, maxAspects));
    }

    private static void addInternal(ILiquidStack output, @NotNull ILiquidStack[] inputs, AspectList.AspectRangeList aspects) {
        RecipeAlchemicalMixer recipe = new RecipeAlchemicalMixer(CraftTweakerMC.getLiquidStacks((ILiquidStack[])inputs), CraftTweakerMC.getLiquidStack((ILiquidStack)output), aspects);
        CraftTweakerAPI.apply((IAction)new Add(recipe));
    }

    @ZenMethod
    public static void remove(ILiquidStack output) {
        CraftTweakerAPI.apply((IAction)new RemoveByOutput(CraftTweakerMC.getLiquidStack((ILiquidStack)output)));
    }

    private static List<RecipeAlchemicalMixer> getRecipesByOutput(FluidStack stack) {
        return CraftingRegistry.alchemicalMixingRecipes.stream().filter(recipe -> recipe.output.isFluidStackIdentical(stack)).collect(Collectors.toCollection(ArrayList::new));
    }

    public static class RemoveAll
    implements IAction {
        protected RemoveAll() {
        }

        public void apply() {
            CraftingRegistry.alchemicalMixingRecipes.clear();
        }

        public String describe() {
            return String.format("Removing all %s recipes", AlchemicalMixer.NAME);
        }
    }

    public static class RemoveByOutput
    implements IAction {
        FluidStack output;

        protected RemoveByOutput(FluidStack output) {
            this.output = output;
        }

        public void apply() {
            CraftingRegistry.alchemicalMixingRecipes.removeAll(AlchemicalMixer.getRecipesByOutput(this.output));
        }

        public String describe() {
            return String.format("Removing %s recipes with output: %s", AlchemicalMixer.NAME, this.output.toString());
        }
    }

    public static class Add
    implements IAction {
        RecipeAlchemicalMixer recipe;

        public Add(RecipeAlchemicalMixer recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            CraftingRegistry.alchemicalMixingRecipes.add(this.recipe);
        }

        public String describe() {
            return String.format("Adding %s recipe: %s", AlchemicalMixer.NAME, ((Object)((Object)this.recipe)).toString());
        }
    }
}

