/*
 * Decompiled with CFR 0.152.
 */
package soot.item;

import com.google.common.collect.Multimap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import soot.item.ItemElixir;
import soot.network.PacketHandler;
import soot.network.message.MessageAlchemyRingFX;
import soot.network.message.MessageGauntletActivate;
import soot.network.message.MessageGauntletDodge;
import soot.network.message.MessageGauntletRotate;
import soot.particle.ParticleUtilSoot;
import soot.projectiles.ProjectileFireBlast;
import soot.util.Attributes;
import teamroots.embers.api.projectile.EffectDamage;
import teamroots.embers.api.projectile.IProjectileEffect;

public class ItemAlchemyGauntlet
extends Item {
    static int escapeCooldown;

    public ItemAlchemyGauntlet() {
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("soot", "gauntlet_state"), (stack, worldIn, entityIn) -> this.getGauntletState(stack, entityIn));
        this.func_185043_a(new ResourceLocation("soot", "gauntlet_hand"), (stack, worldIn, entityIn) -> this.getGauntletHand(stack, entityIn));
    }

    public void activateBlock(ItemStack stack, EntityLivingBase player, EnumHand hand, BlockPos pos, EnumFacing facing) {
        ItemStack elixir = this.getElixir(stack, player);
        if (!elixir.func_190926_b()) {
            ItemElixir itemElixir = (ItemElixir)elixir.func_77973_b();
            itemElixir.activateBlock(stack, elixir, player, hand, pos, facing);
        }
    }

    public void activate(ItemStack stack, EntityLivingBase player, EnumHand hand, Vec3d dir) {
        double handmod = player.func_184600_cs() == EnumHand.MAIN_HAND ? 1.0 : -1.0;
        double posX = player.field_70165_t + player.func_70040_Z().field_72450_a + handmod * ((double)player.field_70130_N / 2.0) * Math.sin(Math.toRadians(-player.field_70177_z - 90.0f));
        double posY = player.field_70163_u + (double)player.func_70047_e() - 0.2 + player.func_70040_Z().field_72448_b;
        double posZ = player.field_70161_v + player.func_70040_Z().field_72449_c + handmod * ((double)player.field_70130_N / 2.0) * Math.cos(Math.toRadians(-player.field_70177_z - 90.0f));
        ItemStack elixir = this.getElixir(stack, player);
        if (!elixir.func_190926_b()) {
            ItemElixir itemElixir = (ItemElixir)elixir.func_77973_b();
            itemElixir.activate(stack, elixir, player, hand, dir);
            Vec3d emitPos = new Vec3d(posX, posY, posZ);
            ProjectileFireBlast projectile = new ProjectileFireBlast((Entity)player, emitPos, emitPos.func_178787_e(player.func_70040_Z().func_186678_a(10.0)), (IProjectileEffect)new EffectDamage(200.0f, x -> DamageSource.field_76369_e, 0, 0.0), this.getElixirColor(elixir), 3, 33, 3.0);
            projectile.shoot(player.field_70170_p);
        }
    }

    public void dodge(ItemStack stack, EntityLivingBase player, EnumHand hand, Vec3d visualPos) {
        ItemStack elixir = this.getElixir(stack, player);
        Color mainColor = this.getElixirColor(elixir);
        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageAlchemyRingFX(visualPos.field_72450_a, visualPos.field_72448_b, visualPos.field_72449_c, mainColor, 30, 2.0, true));
    }

    public void rotate(ItemStack stack, EntityLivingBase player, EnumHand hand) {
        NBTTagCompound compound = this.getOrCreateTagCompound(stack);
        compound.func_74768_a("rotation", compound.func_74762_e("rotation") + 1);
    }

    public int getRotation(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            return 0;
        }
        return compound.func_74762_e("rotation");
    }

    public ItemStack getElixir(ItemStack stack, EntityLivingBase entity) {
        List<ItemStack> elixirs = ItemAlchemyGauntlet.getElixirs(entity);
        int rotation = this.getRotation(stack);
        if (elixirs.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        return elixirs.get(rotation % elixirs.size());
    }

    public static List<ItemStack> getElixirs(EntityLivingBase entity) {
        ArrayList<ItemStack> elixirs = new ArrayList<ItemStack>();
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            InventoryPlayer inventory = player.field_71071_by;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack item = inventory.func_70301_a(i);
                if (!(item.func_77973_b() instanceof ItemElixir)) continue;
                elixirs.add(item);
            }
        }
        return elixirs;
    }

    public boolean isComboReset(EntityLivingBase entity) {
        return !(entity instanceof EntityPlayer) || ((EntityPlayer)entity).func_184825_o(0.0f) >= 1.0f;
    }

    public int getCombo(ItemStack stack, EntityLivingBase entity) {
        NBTTagCompound compound = stack.func_77978_p();
        if (this.isComboReset(entity) || compound == null) {
            return 0;
        }
        return compound.func_74762_e("combo");
    }

    public void setCombo(ItemStack stack, EntityLivingBase entity, int combo) {
        NBTTagCompound compound = this.getOrCreateTagCompound(stack);
        compound.func_74768_a("combo", combo);
    }

    public NBTTagCompound getOrCreateTagCompound(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
            stack.func_77982_d(compound);
        }
        return compound;
    }

    public float getGauntletState(ItemStack stack, EntityLivingBase entity) {
        if (entity != null && entity.func_184607_cu() == stack) {
            return 1.0f;
        }
        return 0.0f;
    }

    public float getGauntletHand(ItemStack stack, EntityLivingBase entity) {
        if (entity != null) {
            if (entity.func_184614_ca() == stack) {
                return entity.func_184591_cq() == EnumHandSide.RIGHT ? 0.0f : 1.0f;
            }
            return entity.func_184591_cq() == EnumHandSide.LEFT ? 0.0f : 1.0f;
        }
        return 1.0f;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (escapeCooldown > 0) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        EntityLivingBase entityLiving;
        --escapeCooldown;
        if (entity instanceof EntityLivingBase && this.isComboReset(entityLiving = (EntityLivingBase)entity)) {
            this.setCombo(stack, entityLiving, 0);
        }
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        int combo = this.getCombo(stack, attacker);
        Attributes.increaseAttraction((Entity)target, combo);
        return super.func_77644_a(stack, target, attacker);
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        int combo = this.getCombo(stack, entityLiving);
        entityLiving.field_70159_w = 0.0;
        entityLiving.field_70181_x = entityLiving.field_70122_E ? 0.0 : 0.3 / (0.1 * (double)combo + 1.0);
        entityLiving.field_70179_y = 0.0;
        this.setCombo(stack, entityLiving, combo + 1);
        if (entityLiving.field_70170_p.field_72995_K) {
            // empty if block
        }
        return super.onEntitySwing(entityLiving, stack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int timeLeft) {
        World world = player.field_70170_p;
        if (world.field_72995_K) {
            Vec3d endPos;
            double handmod = player.func_184600_cs() == EnumHand.MAIN_HAND ? 1.0 : -1.0;
            double posX = player.field_70165_t + player.func_70040_Z().field_72450_a + handmod * ((double)player.field_70130_N / 2.0) * Math.sin(Math.toRadians(-player.field_70177_z - 90.0f));
            double posY = player.field_70163_u + (double)player.func_70047_e() - 0.2 + player.func_70040_Z().field_72448_b;
            double posZ = player.field_70161_v + player.func_70040_Z().field_72449_c + handmod * ((double)player.field_70130_N / 2.0) * Math.cos(Math.toRadians(-player.field_70177_z - 90.0f));
            double chargeCoeff = (double)(this.func_77626_a(stack) - timeLeft) / 20.0;
            double lightningRadius = 0.3;
            double rx = (field_77697_d.nextDouble() - 0.5) * 2.0 * lightningRadius;
            double ry = (field_77697_d.nextDouble() - 0.5) * 2.0 * lightningRadius;
            double rz = (field_77697_d.nextDouble() - 0.5) * 2.0 * lightningRadius;
            ItemStack elixir = this.getElixir(stack, player);
            Color mainColor = this.getElixirColor(elixir);
            Vec3d startPos = player.func_174824_e(1.0f);
            RayTraceResult rayTrace = world.func_147447_a(startPos, endPos = startPos.func_178787_e(player.func_70040_Z().func_186678_a(6.0)), !player.func_70090_H(), true, false);
            if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
                BlockPos pos = rayTrace.func_178782_a();
                IBlockState state = world.func_180495_p(pos);
                AxisAlignedBB aabb = state.func_185918_c(world, pos);
                if (chargeCoeff - 0.1 > 1.0 && !aabb.func_181656_b() && aabb.func_72320_b() > 0.0) {
                    for (int i = 0; i < 12; ++i) {
                        int ax = i >> 2 & 3;
                        int as = 4 - ax >> 2;
                        int bs = 5 - ax >> 2;
                        int v1 = (i & 1) << as | (i & 2) << bs;
                        int v2 = v1 | 1 << ax;
                        int dx1 = v1 & 1;
                        int dy1 = v1 >> 1 & 1;
                        int dz1 = v1 >> 2 & 1;
                        int dx2 = v2 & 1;
                        int dy2 = v2 >> 1 & 1;
                        int dz2 = v2 >> 2 & 1;
                        ParticleUtilSoot.spawnLightning(world, dx1 == 0 ? aabb.field_72340_a : aabb.field_72336_d, dy1 == 0 ? aabb.field_72338_b : aabb.field_72337_e, dz1 == 0 ? aabb.field_72339_c : aabb.field_72334_f, dx2 == 0 ? aabb.field_72340_a : aabb.field_72336_d, dy2 == 0 ? aabb.field_72338_b : aabb.field_72337_e, dz2 == 0 ? aabb.field_72339_c : aabb.field_72334_f, 5, 0.1, mainColor, 0.5, 2);
                    }
                }
            }
            if (chargeCoeff > 0.1) {
                double scale = MathHelper.func_151238_b((double)0.0, (double)1.0, (double)(chargeCoeff - 0.1));
                ParticleUtilSoot.spawnParticleCube(world, posX, posY, posZ, 0.0, 0.0, 0.0, mainColor, (float)(0.5 * scale), 5);
                ParticleUtilSoot.spawnLightning(world, posX, posY, posZ, posX + rx, posY + ry, posZ + rz, 10, 0.1, mainColor, 0.5, 5);
            }
        }
    }

    private Color getElixirColor(ItemStack elixir) {
        if (!elixir.func_190926_b()) {
            ItemElixir elixirItem = (ItemElixir)elixir.func_77973_b();
            Color color = elixirItem.getColor(elixir);
            return color != null ? color : Color.WHITE;
        }
        return Color.WHITE;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase player, int timeLeft) {
        World world = player.field_70170_p;
        double chargeCoeff = (double)(this.func_77626_a(stack) - timeLeft) / 20.0;
        if (world.field_72995_K) {
            double handmod = player.func_184600_cs() == EnumHand.MAIN_HAND ? 1.0 : -1.0;
            ItemStack elixir = this.getElixir(stack, player);
            Color mainColor = this.getElixirColor(elixir);
            double posX = player.field_70165_t + player.func_70040_Z().field_72450_a + handmod * ((double)player.field_70130_N / 2.0) * Math.sin(Math.toRadians(-player.field_70177_z - 90.0f));
            double posY = player.field_70163_u + (double)player.func_70047_e() - 0.2 + player.func_70040_Z().field_72448_b;
            double posZ = player.field_70161_v + player.func_70040_Z().field_72449_c + handmod * ((double)player.field_70130_N / 2.0) * Math.cos(Math.toRadians(-player.field_70177_z - 90.0f));
            if (chargeCoeff > 0.1) {
                if (chargeCoeff - 0.1 > 1.0) {
                    player.field_70159_w = 0.0;
                    player.field_70181_x = player.field_70122_E ? 0.0 : 0.2;
                    player.field_70179_y = 0.0;
                    ParticleUtilSoot.spawnCubeRing(world, posX, posY, posZ, mainColor, 30, 1.0);
                    RayTraceResult rayTrace = this.getTrace(player, world, posX, posY, posZ);
                    if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
                        BlockPos pos = rayTrace.func_178782_a();
                        EnumFacing side = rayTrace.field_178784_b;
                        PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGauntletActivate(player.func_184600_cs(), pos, side, rayTrace.field_72307_f.field_72450_a, rayTrace.field_72307_f.field_72448_b, rayTrace.field_72307_f.field_72449_c));
                    } else {
                        Vec3d look = player.func_70040_Z();
                        PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGauntletActivate(player.func_184600_cs(), look.field_72450_a, look.field_72448_b, look.field_72449_c));
                    }
                }
            } else if (Minecraft.func_71410_x().field_71474_y.field_74368_y.func_151470_d()) {
                if (escapeCooldown <= 0) {
                    escapeCooldown = 40;
                    Vec3d forward = player.func_189651_aD();
                    player.field_70159_w = -forward.field_72450_a;
                    player.field_70181_x = player.field_70122_E ? 0.1 : 0.0;
                    player.field_70179_y = -forward.field_72449_c;
                    PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGauntletDodge(player.func_184600_cs(), new Vec3d(posX, posY, posZ)));
                }
            } else {
                PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGauntletRotate(player.func_184600_cs()));
            }
        }
    }

    private RayTraceResult getTrace(EntityLivingBase player, World world, double posX, double posY, double posZ) {
        Vec3d startPos = new Vec3d(posX, posY, posZ);
        Vec3d endPos = startPos.func_178787_e(player.func_70040_Z().func_186678_a(2.0));
        return world.func_147447_a(startPos, endPos, !player.func_70090_H(), true, false);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(equipmentSlot, stack);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", -3.2, 0));
        }
        return multimap;
    }
}

