/*
 * Decompiled with CFR 0.152.
 */
package soot.item;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.ItemFluidContainer;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import soot.brewing.CaskManager;
import soot.util.FluidUtil;
import soot.util.IItemColored;
import soot.util.MiscUtil;

public class ItemMug
extends ItemFluidContainer
implements IItemColored {
    public static final int MAX_STACK_SIZE = 8;
    public static final int CAPACITY = 250;

    public ItemMug() {
        super(250);
        this.func_77627_a(true);
        this.func_77625_d(8);
        this.func_185043_a(new ResourceLocation("fillmodel"), (stack, worldIn, entityIn) -> {
            CaskManager.CaskLiquid liquid = this.getCaskLiquid(stack);
            if (liquid != null) {
                return liquid.model;
            }
            return 0.0f;
        });
    }

    public CaskManager.CaskLiquid getCaskLiquid(ItemStack stack) {
        return CaskManager.getFromFluid(net.minecraftforge.fluids.FluidUtil.getFluidContained((ItemStack)stack));
    }

    public ItemStack getEmpty() {
        return new ItemStack((Item)this);
    }

    public ItemStack getFilled(CaskManager.CaskLiquid liquid) {
        ItemStack filled = new ItemStack((Item)this);
        IFluidHandlerItem tank = (IFluidHandlerItem)filled.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (tank != null) {
            tank.fill(new FluidStack(liquid.fluid, this.capacity), true);
        }
        return filled;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)this.getEmpty());
            items.addAll((Collection)CaskManager.liquids.stream().map(this::getFilled).collect(Collectors.toList()));
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        FluidStack fluid;
        CaskManager.CaskLiquid liquid;
        EntityPlayer entityplayer;
        EntityPlayer entityPlayer = entityplayer = entityLiving instanceof EntityPlayer ? (EntityPlayer)entityLiving : null;
        if (!worldIn.field_72995_K && (liquid = CaskManager.getFromFluid(fluid = net.minecraftforge.fluids.FluidUtil.getFluidContained((ItemStack)stack))) != null) {
            liquid.applyEffects(entityLiving, (Entity)entityplayer, (Entity)entityplayer, fluid);
        }
        if (entityplayer instanceof EntityPlayerMP) {
            CriteriaTriggers.field_193138_y.func_193148_a((EntityPlayerMP)entityplayer, stack);
        }
        if (entityplayer != null) {
            entityplayer.func_71029_a(StatList.func_188057_b((Item)this));
        }
        if (entityplayer == null || !entityplayer.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                return this.getEmpty();
            }
            if (entityplayer != null) {
                entityplayer.field_71071_by.func_70441_a(this.getEmpty());
            }
        }
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        FluidStack fluid = net.minecraftforge.fluids.FluidUtil.getFluidContained((ItemStack)stack);
        return (int)(FluidUtil.getModifier(fluid, "viscosity") / 1000.0f * 35.0f);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (net.minecraftforge.fluids.FluidUtil.getFluidContained((ItemStack)stack) == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public String func_77653_i(ItemStack stack) {
        FluidStack fluid = net.minecraftforge.fluids.FluidUtil.getFluidContained((ItemStack)stack);
        if (fluid != null) {
            return I18n.func_74837_a((String)"item.mug.name", (Object[])new Object[]{fluid.getLocalizedName()});
        }
        return I18n.func_74838_a((String)"item.mug.empty.name");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        CaskManager.CaskLiquid liquid = this.getCaskLiquid(stack);
        if (liquid != null) {
            MiscUtil.addPotionEffectTooltip(liquid.getEffects(), tooltip, 1.0f);
        }
    }

    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new FluidHandlerItemStack(stack, this.capacity){

            public int fill(FluidStack resource, boolean doFill) {
                if (resource == null || resource.amount < this.capacity) {
                    return 0;
                }
                return super.fill(resource, doFill);
            }
        };
    }

    @Override
    public int getColorFromItemstack(ItemStack stack, int tintIndex) {
        CaskManager.CaskLiquid liquid;
        if (tintIndex == 1 && (liquid = this.getCaskLiquid(stack)) != null) {
            return liquid.color;
        }
        return -1;
    }
}

