/*
 * Decompiled with CFR 0.152.
 */
package soot.itemmod;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import soot.Registry;
import soot.util.MiscUtil;
import teamroots.embers.api.itemmod.ItemModUtil;
import teamroots.embers.api.itemmod.ModifierBase;
import teamroots.embers.gui.GuiCodex;

public class ModifierMundane
extends ModifierBase {
    static final UUID ATTACK_DAMAGE_MODIFIER = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    static final UUID ATTACK_BONUS_UUID = UUID.fromString("051b0eb9-ecbd-402e-83d6-e99455da641c");
    public static final String CODE_STAT = MiscUtil.generateFormatMatchCode(114);
    public static final String CODE_NOSTAT = MiscUtil.generateFormatMatchCode(115);
    public static final String GLOW_FORMAT = "!=!";
    public static WeakHashMap<EntityLivingBase, Double> ATTRIBUTE_CACHE = new WeakHashMap();

    public ModifierMundane() {
        super(ModifierBase.EnumType.TOOL, "mundane", 0.0, false);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean canApplyTo(ItemStack stack) {
        return super.canApplyTo(stack) && MiscUtil.getToolMaterial(stack.func_77973_b()) != null;
    }

    @SubscribeEvent
    public void onTick(LivingEvent.LivingUpdateEvent event) {
        boolean isMundane;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        ItemStack stack = entity.func_184614_ca();
        IAttributeInstance instance = entity.func_110148_a(SharedMonsterAttributes.field_111264_e);
        boolean bl = isMundane = ItemModUtil.hasHeat((ItemStack)stack) && ItemModUtil.hasModifier((ItemStack)stack, (ModifierBase)Registry.MUNDANE);
        if (instance != null) {
            if (isMundane) {
                double mundaneBonus = this.getMundaneBonus(stack);
                AttributeModifier modifier = instance.func_111127_a(ATTACK_BONUS_UUID);
                if (modifier != null) {
                    double currentBonus = ATTRIBUTE_CACHE.getOrDefault(entity, modifier.func_111164_d());
                    if (currentBonus != mundaneBonus) {
                        instance.func_111124_b(modifier);
                    }
                } else {
                    instance.func_111121_a(new AttributeModifier(ATTACK_BONUS_UUID, "mundane_bonus", mundaneBonus, 0));
                }
                ATTRIBUTE_CACHE.put(entity, mundaneBonus);
            } else {
                AttributeModifier modifier = instance.func_111127_a(ATTACK_BONUS_UUID);
                if (modifier != null) {
                    instance.func_111124_b(modifier);
                }
                ATTRIBUTE_CACHE.remove(entity);
            }
        }
    }

    public double getMundaneBonus(ItemStack stack) {
        Item item = stack.func_77973_b();
        Item.ToolMaterial material = MiscUtil.getToolMaterial(item);
        int level = ItemModUtil.getModifierLevel((ItemStack)stack, (ModifierBase)Registry.MUNDANE);
        double itemAttack = ModifierMundane.calculateAttributeTotal(item.getAttributeModifiers(EntityEquipmentSlot.MAINHAND, stack).get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a()));
        double bonus = 3.0 + (double)material.func_78000_c() - itemAttack;
        return Math.min((double)level, Math.abs(bonus)) * Math.signum(bonus);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOW)
    public void onTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        EntityPlayer player = event.getEntityPlayer();
        if (player == null) {
            return;
        }
        boolean isExpanded = GuiScreen.func_146272_n();
        if (this.isAttributeStrippable(stack)) {
            EntityEquipmentSlot slot;
            Multimap slotAttributes;
            AttributeModifier selectedModifier;
            List tooltip = event.getToolTip();
            EntityEquipmentSlot[] entityEquipmentSlotArray = EntityEquipmentSlot.values();
            int n = entityEquipmentSlotArray.length;
            block0: for (int i = 0; i < n && (selectedModifier = this.getAttackDamageModifier((slotAttributes = stack.func_111283_C(slot = entityEquipmentSlotArray[i])).get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a()))) != null; ++i) {
                boolean stat = selectedModifier.func_111167_a().equals(ATTACK_DAMAGE_MODIFIER);
                String check = this.getAttribute(stack, player, SharedMonsterAttributes.field_111264_e.func_111108_a(), selectedModifier.func_111164_d(), stat);
                double mundaneBonus = this.getMundaneBonus(stack);
                for (int i2 = 1; i2 < tooltip.size(); ++i2) {
                    if (!((String)tooltip.get(i2)).equals(check)) continue;
                    String modifiedAttribute = this.getModifiedAttribute(stack, player, SharedMonsterAttributes.field_111264_e.func_111108_a(), selectedModifier.func_111164_d(), mundaneBonus, stat, isExpanded);
                    String finalText = "";
                    int e = 0;
                    for (String string : modifiedAttribute.split(Pattern.quote(GLOW_FORMAT))) {
                        finalText = finalText + (e % 2 == 0 ? string : MiscUtil.generateEmptyString(string));
                        ++e;
                    }
                    tooltip.set(i2, finalText);
                    continue block0;
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTooltipRender(RenderTooltipEvent.PostText event) {
        ItemStack stack = event.getStack();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        boolean isExpanded = GuiScreen.func_146272_n();
        ArrayList<Integer> formattedLines = new ArrayList<Integer>();
        List text = event.getLines();
        for (int i = 0; i < text.size(); ++i) {
            if (!((String)text.get(i)).endsWith(CODE_STAT) && !((String)text.get(i)).endsWith(CODE_NOSTAT)) continue;
            formattedLines.add(i);
        }
        if (formattedLines.size() > 0) {
            FontRenderer fontRenderer = event.getFontRenderer();
            double mundaneBonus = this.getMundaneBonus(stack);
            GlStateManager.func_179097_i();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GlStateManager.func_179147_l();
            GlStateManager.func_179141_d();
            int func = GL11.glGetInteger((int)3009);
            float ref = GL11.glGetFloat((int)3010);
            ListIterator iterator = formattedLines.listIterator();
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                if (!iterator.hasNext()) break;
                Multimap slotAttributes = stack.func_111283_C(slot);
                AttributeModifier selectedModifier = this.getAttackDamageModifier(slotAttributes.get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a()));
                int index = (Integer)iterator.next();
                boolean stat = ((String)text.get(index)).endsWith(CODE_STAT);
                String modifiedAttribute = this.getModifiedAttribute(stack, (EntityPlayer)player, SharedMonsterAttributes.field_111264_e.func_111108_a(), selectedModifier.func_111164_d(), mundaneBonus, stat, isExpanded);
                int e = 0;
                int xOff = 0;
                for (String string : modifiedAttribute.split(GLOW_FORMAT)) {
                    if (e % 2 == 1) {
                        GuiCodex.drawTextGlowingAura((FontRenderer)fontRenderer, (String)string, (int)(event.getX() + xOff), (int)(event.getY() + (fontRenderer.field_78288_b + 1) * index + 2));
                    }
                    xOff += fontRenderer.func_78256_a(string);
                    ++e;
                }
            }
            GlStateManager.func_179092_a((int)func, (float)ref);
            GlStateManager.func_179118_c();
            GlStateManager.func_179084_k();
            GlStateManager.func_179126_j();
        }
    }

    public AttributeModifier getAttackDamageModifier(Collection<AttributeModifier> attributeModifiers) {
        AttributeModifier selectedModifier = null;
        for (AttributeModifier modifier : attributeModifiers) {
            if (!modifier.func_111167_a().equals(ATTACK_DAMAGE_MODIFIER) && (modifier.func_111169_c() != 0 || selectedModifier != null)) continue;
            selectedModifier = modifier;
        }
        return selectedModifier;
    }

    public String getAttribute(ItemStack stack, EntityPlayer player, String attribute, double amount, boolean isStat) {
        boolean flag = false;
        if (isStat) {
            amount += player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b();
            amount += (double)EnchantmentHelper.func_152377_a((ItemStack)stack, (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED);
            flag = true;
        }
        String check = null;
        String formattedName = I18n.func_135052_a((String)("attribute.name." + attribute), (Object[])new Object[0]);
        if (flag) {
            check = " " + I18n.func_135052_a((String)"attribute.modifier.equals.0", (Object[])new Object[]{ItemStack.field_111284_a.format(amount), formattedName});
        } else if (amount > 0.0) {
            check = TextFormatting.BLUE + " " + I18n.func_135052_a((String)"attribute.modifier.plus.0", (Object[])new Object[]{ItemStack.field_111284_a.format(amount), formattedName});
        } else if (amount < 0.0) {
            check = TextFormatting.RED + " " + I18n.func_135052_a((String)"attribute.modifier.take.0", (Object[])new Object[]{ItemStack.field_111284_a.format(amount *= -1.0), formattedName});
        }
        return check;
    }

    public String getModifiedAttribute(ItemStack stack, EntityPlayer player, String attribute, double amount, double bonus, boolean isStat, boolean isExpanded) {
        boolean flag = false;
        if (isStat) {
            amount += player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b();
            amount += (double)EnchantmentHelper.func_152377_a((ItemStack)stack, (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED);
            flag = true;
        }
        if (!isExpanded) {
            amount += bonus;
        }
        String check = "";
        String formattedName = I18n.func_135052_a((String)("attribute.name." + attribute), (Object[])new Object[0]);
        String formattedAmount = !isExpanded ? ItemStack.field_111284_a.format(Math.abs(amount)) : ItemStack.field_111284_a.format(Math.abs(amount)) + " " + GLOW_FORMAT + String.format("%+.2g", bonus) + GLOW_FORMAT;
        if (flag) {
            check = " " + I18n.func_135052_a((String)"attribute.modifier.equals.0", (Object[])new Object[]{formattedAmount, formattedName});
        } else if (amount > 0.0) {
            check = TextFormatting.BLUE + " " + I18n.func_135052_a((String)"attribute.modifier.plus.0", (Object[])new Object[]{formattedAmount, formattedName});
        } else if (amount < 0.0) {
            check = TextFormatting.RED + " " + I18n.func_135052_a((String)"attribute.modifier.take.0", (Object[])new Object[]{formattedAmount, formattedName});
        }
        if (!isExpanded) {
            check = GLOW_FORMAT + check + GLOW_FORMAT;
        }
        return check + CODE_STAT;
    }

    private boolean isAttributeStrippable(ItemStack stack) {
        return (!stack.func_77942_o() || (stack.func_77978_p().func_74762_e("HideFlags") & 2) == 0) && ItemModUtil.hasHeat((ItemStack)stack) && ItemModUtil.hasModifier((ItemStack)stack, (ModifierBase)Registry.MUNDANE);
    }

    private static double calculateAttributeTotal(Collection<AttributeModifier> modifiers) {
        double attribute = 0.0;
        double multiplier = 0.0;
        double finalMultiplier = 1.0;
        for (AttributeModifier modifier : modifiers) {
            switch (modifier.func_111169_c()) {
                case 0: {
                    attribute += modifier.func_111164_d();
                    break;
                }
                case 1: {
                    multiplier += modifier.func_111164_d();
                    break;
                }
                case 2: {
                    finalMultiplier *= modifier.func_111164_d() + 1.0;
                }
            }
        }
        return (attribute + attribute * multiplier) * finalMultiplier;
    }
}

