/*
 * Decompiled with CFR 0.152.
 */
package soot.network.message;

import io.netty.buffer.ByteBuf;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import soot.particle.ParticleUtilSoot;

public class MessageAlchemyRingFX
implements IMessage {
    double x;
    double y;
    double z;
    Color mainColor;
    int segments;
    double distance;
    boolean withCube;

    public MessageAlchemyRingFX() {
    }

    public MessageAlchemyRingFX(double x, double y, double z, Color mainColor, int segments, double distance, boolean withCube) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.mainColor = mainColor;
        this.segments = segments;
        this.distance = distance;
        this.withCube = withCube;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.mainColor = new Color(buf.readInt(), true);
        this.segments = buf.readInt();
        this.distance = buf.readDouble();
        this.withCube = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeInt(this.mainColor.getRGB());
        buf.writeInt(this.segments);
        buf.writeDouble(this.distance);
        buf.writeBoolean(this.withCube);
    }

    public static class MessageHolder
    implements IMessageHandler<MessageAlchemyRingFX, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(MessageAlchemyRingFX message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                ParticleUtilSoot.spawnCubeRing((World)world, message.x, message.y, message.z, message.mainColor, message.segments, message.distance);
                if (message.withCube) {
                    ParticleUtilSoot.spawnParticleCube((World)world, message.x, message.y, message.z, 0.0, 0.0, 0.0, message.mainColor, 2.0f, 10);
                }
            });
            return null;
        }
    }
}

