/*
 * Decompiled with CFR 0.152.
 */
package soot.network.message;

import io.netty.buffer.ByteBuf;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import soot.particle.ParticleUtilSoot;

public class MessageFireBlastFX
implements IMessage {
    double x;
    double y;
    double z;
    Color color;
    float scale;
    int lifetime;

    public MessageFireBlastFX() {
    }

    public MessageFireBlastFX(double x, double y, double z, Color color, float scale, int lifetime) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.color = color;
        this.scale = scale;
        this.lifetime = lifetime;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.color = new Color(buf.readInt(), true);
        this.scale = buf.readFloat();
        this.lifetime = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeInt(this.color.getRGB());
        buf.writeFloat(this.scale);
        buf.writeInt(this.lifetime);
    }

    public static class MessageHolder
    implements IMessageHandler<MessageFireBlastFX, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(MessageFireBlastFX message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                ParticleUtilSoot.spawnFireBlast((World)world, message.x, message.y, message.z, message.color, message.scale, message.lifetime);
            });
            return null;
        }
    }
}

