/*
 * Decompiled with CFR 0.152.
 */
package soot.network.message;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import soot.item.ItemAlchemyGauntlet;

public class MessageGauntletActivate
implements IMessage {
    EnumHand hand;
    Type type;
    BlockPos pos;
    EnumFacing side;
    double hitX;
    double hitY;
    double hitZ;
    double faceX;
    double faceY;
    double faceZ;

    public MessageGauntletActivate() {
    }

    public MessageGauntletActivate(EnumHand hand, BlockPos pos, EnumFacing side, double hitX, double hitY, double hitZ) {
        this.type = Type.Block;
        this.hand = hand;
        this.pos = pos;
        this.side = side;
        this.hitX = hitX;
        this.hitY = hitY;
        this.hitZ = hitZ;
    }

    public MessageGauntletActivate(EnumHand hand, double faceX, double faceY, double faceZ) {
        this.type = Type.Direction;
        this.faceX = faceX;
        this.faceY = faceY;
        this.faceZ = faceZ;
        this.hand = hand;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer buffer = new PacketBuffer(buf);
        this.hand = (EnumHand)buffer.func_179257_a(EnumHand.class);
        this.type = (Type)buffer.func_179257_a(Type.class);
        switch (this.type) {
            case Block: {
                this.pos = buffer.func_179259_c();
                this.side = (EnumFacing)buffer.func_179257_a(EnumFacing.class);
                this.hitX = buffer.readDouble();
                this.hitY = buffer.readDouble();
                this.hitZ = buffer.readDouble();
                break;
            }
            case Direction: {
                this.faceX = buffer.readDouble();
                this.faceY = buffer.readDouble();
                this.faceZ = buffer.readDouble();
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer buffer = new PacketBuffer(buf);
        buffer.func_179249_a((Enum)this.hand);
        buffer.func_179249_a((Enum)this.type);
        switch (this.type) {
            case Block: {
                buffer.func_179255_a(this.pos);
                buffer.func_179249_a((Enum)this.side);
                buffer.writeDouble(this.hitX);
                buffer.writeDouble(this.hitY);
                buffer.writeDouble(this.hitZ);
                break;
            }
            case Direction: {
                buffer.writeDouble(this.faceX);
                buffer.writeDouble(this.faceY);
                buffer.writeDouble(this.faceZ);
            }
        }
    }

    public static class MessageHolder
    implements IMessageHandler<MessageGauntletActivate, IMessage> {
        public IMessage onMessage(MessageGauntletActivate message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            WorldServer world = player.func_71121_q();
            world.func_152344_a(() -> {
                ItemStack held = player.func_184586_b(message.hand);
                if (held.func_77973_b() instanceof ItemAlchemyGauntlet) {
                    ItemAlchemyGauntlet gauntlet = (ItemAlchemyGauntlet)held.func_77973_b();
                    switch (message.type) {
                        case Block: {
                            gauntlet.activateBlock(held, (EntityLivingBase)player, message.hand, message.pos, message.side);
                            break;
                        }
                        case Direction: {
                            gauntlet.activate(held, (EntityLivingBase)player, message.hand, new Vec3d(message.faceX, message.faceY, message.faceZ));
                        }
                    }
                }
            });
            return null;
        }
    }

    static enum Type {
        Block,
        Direction;

    }
}

