/*
 * Decompiled with CFR 0.152.
 */
package soot.particle;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import teamroots.embers.particle.IEmberParticle;

public class ParticleCube
extends Particle
implements IEmberParticle {
    float yaw;
    float prevYaw;
    float pitch;
    float prevPitch;
    float scaleStart;
    float scaleEnd;
    public static final ResourceLocation texture = new ResourceLocation("soot", "entity/particle_dawnstone");

    public ParticleCube(World world, double x, double y, double z, double vx, double vy, double vz, Color color, float scale, int lifetime) {
        super(world, x, y, z, vx, vy, vz);
        this.field_70552_h = (float)color.getRed() / 255.0f;
        this.field_70553_i = (float)color.getGreen() / 255.0f;
        this.field_70551_j = (float)color.getBlue() / 255.0f;
        this.field_82339_as = (float)color.getAlpha() / 255.0f;
        this.field_70544_f = scale;
        this.field_70547_e = lifetime;
        this.field_187129_i = vx;
        this.field_187130_j = vy;
        this.field_187131_k = vz;
        this.yaw = (float)(this.field_187136_p.nextDouble() * Math.PI * 2.0);
        this.pitch = (float)(this.field_187136_p.nextDouble() * Math.PI * 2.0);
        this.scaleStart = scale;
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(texture.toString());
        this.func_187117_a(sprite);
    }

    public int func_70537_b() {
        return 1;
    }

    public void func_189213_a() {
        super.func_189213_a();
        this.prevYaw = this.yaw;
        this.prevPitch = this.pitch;
    }

    public boolean alive() {
        return this.field_70546_d < this.field_70547_e;
    }

    public boolean isAdditive() {
        return true;
    }

    public boolean renderThroughBlocks() {
        return false;
    }

    public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        float minU = this.field_187119_C.func_94209_e();
        float maxU = this.field_187119_C.func_94212_f();
        float minV = this.field_187119_C.func_94206_g();
        float maxV = this.field_187119_C.func_94210_h();
        double lifeCoeff = ((float)this.field_70546_d + partialTicks) / (float)this.field_70547_e;
        float scale = 0.1f * (float)MathHelper.func_151238_b((double)this.scaleEnd, (double)this.scaleStart, (double)Math.sin(lifeCoeff * Math.PI));
        scale = (float)Math.sqrt(scale);
        float yaw = this.yaw + (this.yaw - this.prevYaw) * partialTicks;
        float pitch = this.pitch + (this.pitch - this.prevPitch) * partialTicks;
        float x = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float y = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float z = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        double sina = Math.sin(yaw);
        double cosa = Math.cos(yaw);
        double sinb = Math.sin(pitch);
        double cosb = Math.cos(pitch);
        Vec3d forward = new Vec3d(cosb, 0.0, sinb);
        Vec3d up = new Vec3d(sina * sinb, cosa, -sina * cosb);
        Vec3d right = new Vec3d(-cosa * sinb, sina, cosa * cosb);
        int lightmap = this.func_189214_a(partialTicks);
        Vec3d[] points = new Vec3d[]{new Vec3d((double)(-scale), (double)(-scale), (double)(-scale)), new Vec3d((double)(-scale), (double)(-scale), (double)scale), new Vec3d((double)(-scale), (double)scale, (double)(-scale)), new Vec3d((double)(-scale), (double)scale, (double)scale), new Vec3d((double)scale, (double)(-scale), (double)(-scale)), new Vec3d((double)scale, (double)(-scale), (double)scale), new Vec3d((double)scale, (double)scale, (double)(-scale)), new Vec3d((double)scale, (double)scale, (double)scale)};
        for (int i = 0; i < points.length; ++i) {
            Vec3d v = points[i];
            points[i] = new Vec3d((double)x + forward.field_72450_a * v.field_72450_a + forward.field_72448_b * v.field_72448_b + forward.field_72449_c * v.field_72449_c, (double)y + up.field_72450_a * v.field_72450_a + up.field_72448_b * v.field_72448_b + up.field_72449_c * v.field_72449_c, (double)z + right.field_72450_a * v.field_72450_a + right.field_72448_b * v.field_72448_b + right.field_72449_c * v.field_72449_c);
        }
        ParticleCube.addBox(buffer, points[0], points[1], points[2], points[3], points[4], points[5], points[6], points[7], new Color(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as), lightmap, minU, minV, maxU, maxV);
    }

    private static void addBox(BufferBuilder buffer, Vec3d a, Vec3d b, Vec3d c, Vec3d d, Vec3d e, Vec3d f, Vec3d g, Vec3d h, Color color, int lightmap, double minu, double minv, double maxu, double maxv) {
        int j = lightmap >> 16 & 0xFFFF;
        int k = lightmap & 0xFFFF;
        buffer.func_181662_b(a.field_72450_a, a.field_72448_b, a.field_72449_c).func_187315_a(minu, minv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(b.field_72450_a, b.field_72448_b, b.field_72449_c).func_187315_a(maxu, minv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(f.field_72450_a, f.field_72448_b, f.field_72449_c).func_187315_a(maxu, maxv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(e.field_72450_a, e.field_72448_b, e.field_72449_c).func_187315_a(minu, maxv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(c.field_72450_a, c.field_72448_b, c.field_72449_c).func_187315_a(minu, minv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(d.field_72450_a, d.field_72448_b, d.field_72449_c).func_187315_a(maxu, minv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(h.field_72450_a, h.field_72448_b, h.field_72449_c).func_187315_a(maxu, maxv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(g.field_72450_a, g.field_72448_b, g.field_72449_c).func_187315_a(minu, maxv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(a.field_72450_a, a.field_72448_b, a.field_72449_c).func_187315_a(minu, minv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(e.field_72450_a, e.field_72448_b, e.field_72449_c).func_187315_a(maxu, minv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(g.field_72450_a, g.field_72448_b, g.field_72449_c).func_187315_a(maxu, maxv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(c.field_72450_a, c.field_72448_b, c.field_72449_c).func_187315_a(minu, maxv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(b.field_72450_a, b.field_72448_b, b.field_72449_c).func_187315_a(minu, minv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(f.field_72450_a, f.field_72448_b, f.field_72449_c).func_187315_a(maxu, minv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(h.field_72450_a, h.field_72448_b, h.field_72449_c).func_187315_a(maxu, maxv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(d.field_72450_a, d.field_72448_b, d.field_72449_c).func_187315_a(minu, maxv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(a.field_72450_a, a.field_72448_b, a.field_72449_c).func_187315_a(minu, minv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(b.field_72450_a, b.field_72448_b, b.field_72449_c).func_187315_a(maxu, minv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(d.field_72450_a, d.field_72448_b, d.field_72449_c).func_187315_a(maxu, maxv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(c.field_72450_a, c.field_72448_b, c.field_72449_c).func_187315_a(minu, maxv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(e.field_72450_a, e.field_72448_b, e.field_72449_c).func_187315_a(minu, minv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(f.field_72450_a, f.field_72448_b, f.field_72449_c).func_187315_a(maxu, minv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(h.field_72450_a, h.field_72448_b, h.field_72449_c).func_187315_a(maxu, maxv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(g.field_72450_a, g.field_72448_b, g.field_72449_c).func_187315_a(minu, maxv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
    }
}

