/*
 * Decompiled with CFR 0.152.
 */
package soot.recipe;

import com.google.common.collect.Lists;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import mezz.jei.util.Translator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.registries.ForgeRegistry;
import soot.Registry;
import soot.brewing.CaskManager;
import soot.brewing.FluidModifier;
import soot.brewing.deliverytypes.DeliveryBlast;
import soot.recipe.CatalystInfo;
import soot.recipe.ItemLiverStampingRecipe;
import soot.recipe.ItemRenameStampingRecipe;
import soot.recipe.RecipeAlchemicalMixer;
import soot.recipe.RecipeStill;
import soot.recipe.RecipeStillDoubleDistillation;
import soot.recipe.RecipeStillModifier;
import soot.recipe.RecipeStillModifierFood;
import soot.tile.TileEntityStillBase;
import soot.util.FluidUtil;
import soot.util.MiscUtil;
import teamroots.embers.ConfigManager;
import teamroots.embers.Embers;
import teamroots.embers.RegistryManager;
import teamroots.embers.api.alchemy.AspectList;
import teamroots.embers.recipe.AlchemyRecipe;
import teamroots.embers.recipe.FluidMixingRecipe;
import teamroots.embers.recipe.ItemMeltingRecipe;
import teamroots.embers.recipe.ItemStampingRecipe;
import teamroots.embers.recipe.RecipeRegistry;
import teamroots.embers.util.IngredientSpecial;

public class CraftingRegistry {
    public static HashSet<ResourceLocation> REMOVE_RECIPE_BY_RL = new HashSet();
    public static ArrayList<RecipeAlchemicalMixer> alchemicalMixingRecipes = new ArrayList();
    public static ArrayList<RecipeStill> stillRecipes = new ArrayList();
    public static ArrayList<CatalystInfo> stillCatalysts = new ArrayList();

    public static void preInit() {
        MinecraftForge.EVENT_BUS.register(CraftingRegistry.class);
    }

    public static void removeRecipe(ResourceLocation resloc) {
        REMOVE_RECIPE_BY_RL.add(resloc);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void removeRecipes(RegistryEvent.Register<IRecipe> event) {
        ForgeRegistry reg = (ForgeRegistry)event.getRegistry();
        for (IRecipe recipe : reg) {
            REMOVE_RECIPE_BY_RL.stream().filter(loc -> loc.equals((Object)recipe.getRegistryName())).forEach(loc -> {
                IRecipe cfr_ignored_0 = (IRecipe)reg.remove(recipe.getRegistryName());
            });
        }
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        OreIngredient ingotAntimony = new OreIngredient("ingotAntimony");
        OreIngredient ingotLead = new OreIngredient("ingotLead");
        OreIngredient ingotNickel = new OreIngredient("ingotNickel");
        OreIngredient blankGlass = new OreIngredient("blockGlassColorless");
        IngredientSpecial leadPickaxe = new IngredientSpecial(stack -> {
            Item item = stack.func_77973_b();
            return item instanceof ItemTool && item.getToolClasses(stack).contains("pickaxe") && ((ItemTool)item).func_77861_e().toLowerCase().contains("lead");
        });
        RecipeRegistry.alchemyRecipes.add(new AlchemyRecipe(new AspectList.AspectRangeList().setRange("copper", 16, 32).setRange("lead", 32, 64), (Ingredient)blankGlass, (List)Lists.newArrayList((Object[])new Ingredient[]{ingotLead, Ingredient.func_193367_a((Item)RegistryManager.aspectus_lead), ingotLead, Ingredient.func_193367_a((Item)RegistryManager.archaic_circuit)}), new ItemStack((Block)Registry.ALCHEMY_GLOBE)));
        RecipeRegistry.alchemyRecipes.add(new AlchemyRecipe(new AspectList.AspectRangeList().setRange("iron", 64, 96).setRange("lead", 64, 96), (Ingredient)leadPickaxe, (List)Lists.newArrayList((Object[])new Ingredient[]{ingotAntimony, Ingredient.func_193367_a((Item)Registry.SULFUR_CLUMP), ingotAntimony, Ingredient.func_193367_a((Item)Registry.SIGNET_ANTIMONY)}), new ItemStack((Item)Registry.EITR)));
        RecipeRegistry.alchemyRecipes.add(new AlchemyRecipe(new AspectList.AspectRangeList().setRange("copper", 16, 32).setRange("iron", 32, 48).setRange("lead", 32, 48), Ingredient.func_193367_a((Item)RegistryManager.jet_augment), (List)Lists.newArrayList((Object[])new Ingredient[]{ingotNickel, Ingredient.func_193367_a((Item)Registry.SULFUR_CLUMP), ingotNickel, ingotNickel}), new ItemStack(Registry.WITCH_FIRE)));
        CraftingRegistry.removeRecipe(new ResourceLocation("embers", "archaic_bricks_2"));
        CraftingRegistry.removeRecipe(new ResourceLocation("embers", "plate_caminite_raw"));
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(Registry.STAMP_NUGGET_RAW), new ItemStack(Registry.STAMP_NUGGET), 0.1f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(Registry.STAMP_TEXT_RAW), new ItemStack(Registry.STAMP_TEXT), 0.1f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(Registry.CAMINITE_CLAY), new ItemStack(Registry.CAMINITE_LARGE_TILE), 0.1f);
        int nuggetSize = 16;
        RecipeRegistry.stampingRecipes.add(new ItemStampingRecipe(Ingredient.field_193370_a, FluidRegistry.getFluidStack((String)"iron", (int)nuggetSize), Ingredient.func_193367_a((Item)Registry.STAMP_NUGGET), new ItemStack(Items.field_191525_da)));
        RecipeRegistry.stampingRecipes.add(new ItemStampingRecipe(Ingredient.field_193370_a, FluidRegistry.getFluidStack((String)"gold", (int)nuggetSize), Ingredient.func_193367_a((Item)Registry.STAMP_NUGGET), new ItemStack(Items.field_151074_bl)));
        RecipeRegistry.stampingRecipes.add(new ItemStampingRecipe(Ingredient.field_193370_a, FluidRegistry.getFluidStack((String)"copper", (int)nuggetSize), Ingredient.func_193367_a((Item)Registry.STAMP_NUGGET), new ItemStack(RegistryManager.nugget_copper)));
        RecipeRegistry.stampingRecipes.add(new ItemStampingRecipe(Ingredient.field_193370_a, FluidRegistry.getFluidStack((String)"dawnstone", (int)nuggetSize), Ingredient.func_193367_a((Item)Registry.STAMP_NUGGET), new ItemStack(RegistryManager.nugget_dawnstone)));
        RecipeRegistry.stampingRecipes.add(new ItemStampingRecipe(Ingredient.field_193370_a, FluidRegistry.getFluidStack((String)"lead", (int)nuggetSize), Ingredient.func_193367_a((Item)Registry.STAMP_NUGGET), new ItemStack(RegistryManager.nugget_lead)));
        RecipeRegistry.stampingRecipes.add(new ItemStampingRecipe(Ingredient.field_193370_a, FluidRegistry.getFluidStack((String)"silver", (int)nuggetSize), Ingredient.func_193367_a((Item)Registry.STAMP_NUGGET), new ItemStack(RegistryManager.nugget_silver)));
        if (ConfigManager.enableTin) {
            RecipeRegistry.stampingRecipes.add(new ItemStampingRecipe(Ingredient.field_193370_a, FluidRegistry.getFluidStack((String)"tin", (int)nuggetSize), Ingredient.func_193367_a((Item)Registry.STAMP_NUGGET), new ItemStack(RegistryManager.nugget_tin)));
        }
        if (ConfigManager.enableAluminum) {
            RecipeRegistry.stampingRecipes.add(new ItemStampingRecipe(Ingredient.field_193370_a, FluidRegistry.getFluidStack((String)"aluminum", (int)nuggetSize), Ingredient.func_193367_a((Item)Registry.STAMP_NUGGET), new ItemStack(RegistryManager.nugget_aluminum)));
        }
        if (ConfigManager.enableBronze) {
            RecipeRegistry.stampingRecipes.add(new ItemStampingRecipe(Ingredient.field_193370_a, FluidRegistry.getFluidStack((String)"bronze", (int)nuggetSize), Ingredient.func_193367_a((Item)Registry.STAMP_NUGGET), new ItemStack(RegistryManager.nugget_bronze)));
        }
        if (ConfigManager.enableNickel) {
            RecipeRegistry.stampingRecipes.add(new ItemStampingRecipe(Ingredient.field_193370_a, FluidRegistry.getFluidStack((String)"nickel", (int)nuggetSize), Ingredient.func_193367_a((Item)Registry.STAMP_NUGGET), new ItemStack(RegistryManager.nugget_nickel)));
        }
        if (ConfigManager.enableElectrum) {
            RecipeRegistry.stampingRecipes.add(new ItemStampingRecipe(Ingredient.field_193370_a, FluidRegistry.getFluidStack((String)"electrum", (int)nuggetSize), Ingredient.func_193367_a((Item)Registry.STAMP_NUGGET), new ItemStack(RegistryManager.nugget_electrum)));
        }
        RecipeRegistry.stampingRecipes.add(new ItemLiverStampingRecipe());
        RecipeRegistry.stampingRecipes.add(new ItemRenameStampingRecipe());
        RecipeRegistry.meltingRecipes.add(new ItemMeltingRecipe(Ingredient.func_193367_a((Item)Items.field_151102_aT), FluidRegistry.getFluidStack((String)"sugar", (int)16)));
        ArrayList<Fluid> leveledMetals = new ArrayList<Fluid>();
        leveledMetals.add(FluidRegistry.getFluid((String)"lead"));
        if (ConfigManager.enableTin) {
            leveledMetals.add(FluidRegistry.getFluid((String)"tin"));
        }
        leveledMetals.add(FluidRegistry.getFluid((String)"iron"));
        leveledMetals.add(FluidRegistry.getFluid((String)"copper"));
        leveledMetals.add(FluidRegistry.getFluid((String)"silver"));
        leveledMetals.add(FluidRegistry.getFluid((String)"gold"));
        for (int i = 0; i < leveledMetals.size() - 1; ++i) {
            int e = i + 1;
            FluidStack currentLevel = new FluidStack((Fluid)leveledMetals.get(i), 4);
            FluidStack nextLevel = new FluidStack((Fluid)leveledMetals.get(e), 4);
            CraftingRegistry.addAlchemicalMixingRecipe(nextLevel, new FluidStack[]{currentLevel, FluidRegistry.getFluidStack((String)"alchemical_redstone", (int)3)}, new AspectList.AspectRangeList(AspectList.createStandard((int)0, (int)0, (int)0, (int)0, (int)(e * e * 4)), AspectList.createStandard((int)0, (int)0, (int)0, (int)0, (int)(e * e * 8))));
        }
        CraftingRegistry.addAlchemicalMixingRecipe(FluidRegistry.getFluidStack((String)"antimony", (int)12), new FluidStack[]{FluidRegistry.getFluidStack((String)"lead", (int)8), FluidRegistry.getFluidStack((String)"sugar", (int)4)}, new AspectList.AspectRangeList(AspectList.createStandard((int)0, (int)16, (int)0, (int)16, (int)0), AspectList.createStandard((int)0, (int)32, (int)0, (int)24, (int)0)));
        RecipeRegistry.stampingRecipes.add(new ItemStampingRecipe(Ingredient.func_193367_a((Item)RegistryManager.shard_ember), FluidRegistry.getFluidStack((String)"antimony", (int)144), Ingredient.func_193367_a((Item)RegistryManager.stamp_bar), new ItemStack(Registry.SIGNET_ANTIMONY)));
        RecipeRegistry.stampingRecipes.add(new ItemStampingRecipe(Ingredient.field_193370_a, FluidRegistry.getFluidStack((String)"antimony", (int)144), Ingredient.func_193367_a((Item)RegistryManager.stamp_bar), new ItemStack(Registry.INGOT_ANTIMONY)));
        RecipeRegistry.meltingRecipes.add(new ItemMeltingRecipe((Ingredient)new OreIngredient("ingotAntimony"), FluidRegistry.getFluidStack((String)"antimony", (int)144)));
        OreDictionary.registerOre((String)"ingotAntimony", (ItemStack)new ItemStack(Registry.INGOT_ANTIMONY));
        OreDictionary.registerOre((String)"dustSulfur", (ItemStack)new ItemStack(Registry.SULFUR));
        CraftingRegistry.initAlcoholRecipes();
    }

    private static void initAlcoholRecipes() {
        FluidUtil.registerModifier(new FluidModifier("ale", 0.0f, FluidModifier.EnumType.PRIMARY, FluidModifier.EffectType.POSITIVE){

            @Override
            public void providePotionEffects(EntityLivingBase target, ArrayList<CaskManager.CaskPotionEffect> effects, NBTTagCompound compound, Fluid fluid) {
                float value = this.getOrDefault(compound, fluid);
                effects.add(new CaskManager.CaskPotionEffect(new PotionEffect(Registry.POTION_ALE, (int)value), 4));
            }
        }.setFormatType("name_only"));
        FluidUtil.registerModifier(new FluidModifier("lifedrinker", 0.0f, FluidModifier.EnumType.SECONDARY, FluidModifier.EffectType.POSITIVE){

            @Override
            public void providePotionEffects(EntityLivingBase target, ArrayList<CaskManager.CaskPotionEffect> effects, NBTTagCompound compound, Fluid fluid) {
                float value = this.getOrDefault(compound, fluid);
                effects.add(new CaskManager.CaskPotionEffect(new PotionEffect(Registry.POTION_LIFEDRINKER, (int)value), 0));
            }
        }.setFormatType("name_only"));
        FluidUtil.registerModifier(new FluidModifier("steadfast", 0.0f, FluidModifier.EnumType.SECONDARY, FluidModifier.EffectType.POSITIVE){

            @Override
            public void providePotionEffects(EntityLivingBase target, ArrayList<CaskManager.CaskPotionEffect> effects, NBTTagCompound compound, Fluid fluid) {
                float value = this.getOrDefault(compound, fluid);
                effects.add(new CaskManager.CaskPotionEffect(new PotionEffect(Registry.POTION_STEADFAST, (int)value), 0));
            }
        }.setFormatType("name_only"));
        FluidUtil.registerModifier(new FluidModifier("viscosity", 1000.0f, FluidModifier.EnumType.TERTIARY, FluidModifier.EffectType.NEGATIVE){

            @Override
            public String getFormattedText(NBTTagCompound compound, Fluid fluid) {
                float value = this.getOrDefault(compound, fluid);
                if (value > 1000.0f) {
                    return I18n.func_135052_a((String)"distilling.modifier.dial.slower_chugging", (Object[])new Object[]{Float.valueOf(value)});
                }
                return I18n.func_135052_a((String)"distilling.modifier.dial.faster_chugging", (Object[])new Object[]{Float.valueOf(value)});
            }
        });
        FluidUtil.registerModifier(new FluidModifier("light", 0.0f, FluidModifier.EnumType.TERTIARY, FluidModifier.EffectType.NEUTRAL).setFormatType("name_only"));
        FluidUtil.registerModifier(new FluidModifier("health", 0.0f, FluidModifier.EnumType.TERTIARY, FluidModifier.EffectType.POSITIVE){

            @Override
            public void applyEffect(EntityLivingBase target, NBTTagCompound compound, Fluid fluid) {
                float value = this.getOrDefault(compound, fluid);
                if (value > 0.0f) {
                    target.func_70691_i(value);
                } else if (value < 0.0f) {
                    MiscUtil.damageWithoutInvulnerability((Entity)target, new DamageSource("acid"), value);
                }
            }

            @Override
            public String getFormattedText(NBTTagCompound compound, Fluid fluid) {
                int value = (int)Math.ceil(this.getOrDefault(compound, fluid) / 2.0f);
                DecimalFormat format = Embers.proxy.getDecimalFormat("embers.decimal_format.distilling.health");
                return I18n.func_135052_a((String)"distilling.modifier.dial.health", (Object[])new Object[]{this.getLocalizedName(), format.format(value)});
            }
        });
        FluidUtil.registerModifier(new FluidModifier("hunger", 0.0f, FluidModifier.EnumType.TERTIARY, FluidModifier.EffectType.POSITIVE){

            @Override
            public void applyEffect(EntityLivingBase target, NBTTagCompound compound, Fluid fluid) {
                if (target instanceof EntityPlayer) {
                    int hunger = (int)compound.func_74760_g("hunger");
                    float saturation = compound.func_74760_g("saturation");
                    ((EntityPlayer)target).func_71024_bL().func_75122_a(hunger, saturation);
                }
            }

            @Override
            public String getFormattedText(NBTTagCompound compound, Fluid fluid) {
                int value = (int)Math.ceil(this.getOrDefault(compound, fluid) / 2.0f);
                DecimalFormat format = Embers.proxy.getDecimalFormat("embers.decimal_format.distilling.hunger");
                return I18n.func_135052_a((String)"distilling.modifier.dial.hunger", (Object[])new Object[]{this.getLocalizedName(), format.format(value)});
            }
        });
        FluidUtil.registerModifier(new FluidModifier("saturation", 0.0f, FluidModifier.EnumType.TERTIARY, FluidModifier.EffectType.POSITIVE).setFormatType(null));
        FluidUtil.registerModifier(new FluidModifier("toxicity", 0.0f, FluidModifier.EnumType.TERTIARY, FluidModifier.EffectType.NEGATIVE){

            @Override
            public void applyEffect(EntityLivingBase target, NBTTagCompound compound, Fluid fluid) {
                float value = this.getOrDefault(compound, fluid);
                if (value > 0.0f) {
                    target.func_70690_d(new PotionEffect(MobEffects.field_76431_k, (int)value * 4));
                }
                if (value >= 50.0f) {
                    target.func_70690_d(new PotionEffect(MobEffects.field_76440_q, (int)value * 2));
                }
                if (value >= 100.0f) {
                    target.func_70690_d(new PotionEffect(MobEffects.field_76436_u, (int)value - 50));
                }
                if (value >= 200.0f) {
                    target.func_70690_d(new PotionEffect(MobEffects.field_82731_v, (int)(value - 150.0f)));
                }
            }
        });
        FluidUtil.registerModifier(new FluidModifier("heat", 300.0f, FluidModifier.EnumType.TERTIARY, FluidModifier.EffectType.NEUTRAL){

            @Override
            public void applyEffect(EntityLivingBase target, NBTTagCompound compound, Fluid fluid) {
                float value = this.getOrDefault(compound, fluid);
                if (value > 400.0f) {
                    MiscUtil.damageWithoutInvulnerability((Entity)target, new DamageSource("scalding"), 2.0f);
                    target.func_184185_a(SoundEvents.field_193806_fH, 1.0f, 1.0f);
                    if (target instanceof EntityPlayer) {
                        ((EntityPlayer)target).func_146105_b((ITextComponent)new TextComponentTranslation("message.scalding", new Object[0]), true);
                    }
                }
                if (value > 500.0f) {
                    target.func_70015_d((int)((value - 500.0f) / 10.0f));
                }
            }
        });
        FluidUtil.registerModifier(new FluidModifier("volume", 0.0f, FluidModifier.EnumType.TERTIARY, FluidModifier.EffectType.NEGATIVE){

            @Override
            public void applyEffect(EntityLivingBase target, NBTTagCompound compound, Fluid fluid) {
                float value = this.getOrDefault(compound, fluid);
                if (target.func_70681_au().nextDouble() * 100.0 < (double)value) {
                    target.func_70690_d(new PotionEffect(Registry.POTION_TIPSY, (int)value * 20));
                }
            }
        }.setFormatType("percent"));
        FluidUtil.registerModifier(new FluidModifier("concentration", 0.0f, FluidModifier.EnumType.TERTIARY, FluidModifier.EffectType.POSITIVE).setFormatType("percent"));
        FluidUtil.registerModifier(new FluidModifier("duration", 1.0f, FluidModifier.EnumType.TERTIARY, FluidModifier.EffectType.POSITIVE).setFormatType("multiplier"));
        FluidUtil.registerModifier(new FluidModifier("fuel", 0.0f, FluidModifier.EnumType.TERTIARY, FluidModifier.EffectType.NEUTRAL){

            @Override
            public String getFormattedText(NBTTagCompound compound, Fluid fluid) {
                int burntime = (int)this.getOrDefault(compound, fluid);
                if (burntime > 0) {
                    return super.getFormattedText(compound, fluid);
                }
                return I18n.func_135052_a((String)"distilling.modifier.dial.fire_retardant", (Object[])new Object[]{burntime});
            }
        });
        FluidUtil.registerModifier(new FluidModifier("alchemy_blast", 0.0f, FluidModifier.EnumType.TERTIARY, FluidModifier.EffectType.POSITIVE).setFormatType("name_only"));
        FluidUtil.registerModifier(new FluidModifier("alchemy_blast_radius", 8.0f, FluidModifier.EnumType.TERTIARY, FluidModifier.EffectType.POSITIVE));
        CaskManager.register("alchemy_blast", (gauntlet, elixir, user, fluid) -> {
            float radius = FluidUtil.getModifier(fluid, "alchemy_blast_radius");
            return new DeliveryBlast(user, fluid, 8.0, radius);
        });
        Fluid boiling_wort = FluidRegistry.getFluid((String)"boiling_wort");
        Fluid boiling_potato_juice = FluidRegistry.getFluid((String)"boiling_potato_juice");
        Fluid boiling_beetroot_soup = FluidRegistry.getFluid((String)"boiling_beetroot_soup");
        FluidUtil.setDefaultValue(boiling_beetroot_soup, "hunger", 6.0f);
        FluidUtil.setDefaultValue(boiling_beetroot_soup, "saturation", 0.6f);
        Fluid boiling_verdigris = FluidRegistry.getFluid((String)"boiling_wormwood");
        FluidUtil.setDefaultValue(boiling_verdigris, "toxicity", 100.0f);
        Fluid ale = FluidRegistry.getFluid((String)"dwarven_ale");
        FluidUtil.setDefaultValue(ale, "volume", 20.0f);
        FluidUtil.setDefaultValue(ale, "fuel", 400.0f);
        Fluid inner_fire = FluidRegistry.getFluid((String)"inner_fire");
        FluidUtil.setDefaultValue(inner_fire, "heat", 600.0f);
        FluidUtil.setDefaultValue(inner_fire, "volume", 10.0f);
        FluidUtil.setDefaultValue(inner_fire, "fuel", 1600.0f);
        Fluid umber_ale = FluidRegistry.getFluid((String)"umber_ale");
        Fluid vodka = FluidRegistry.getFluid((String)"vodka");
        FluidUtil.setDefaultValue(vodka, "volume", 30.0f);
        FluidUtil.setDefaultValue(vodka, "fuel", 1200.0f);
        Fluid snowpoff = FluidRegistry.getFluid((String)"snowpoff");
        FluidUtil.setDefaultValue(snowpoff, "heat", 200.0f);
        FluidUtil.setDefaultValue(snowpoff, "volume", 20.0f);
        FluidUtil.setDefaultValue(snowpoff, "fuel", -2000.0f);
        Fluid absinthe = FluidRegistry.getFluid((String)"absinthe");
        FluidUtil.setDefaultValue(absinthe, "toxicity", 50.0f);
        FluidUtil.setDefaultValue(absinthe, "volume", 50.0f);
        FluidUtil.setDefaultValue(absinthe, "fuel", 800.0f);
        Fluid methanol = FluidRegistry.getFluid((String)"methanol");
        FluidUtil.setDefaultValue(methanol, "toxicity", 10.0f);
        FluidUtil.setDefaultValue(methanol, "fuel", 2400.0f);
        ItemStack smallFern = new ItemStack((Block)Blocks.field_150329_H, 1, BlockTallGrass.EnumType.FERN.func_177044_a());
        ItemStack bigFern = new ItemStack((Block)Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.FERN.func_176936_a());
        RecipeRegistry.meltingRecipes.add(new ItemMeltingRecipe((Ingredient)new OreIngredient("cropWheat"), new FluidStack(boiling_wort, 100)));
        RecipeRegistry.meltingRecipes.add(new ItemMeltingRecipe((Ingredient)new OreIngredient("cropPotato"), new FluidStack(boiling_potato_juice, 50)));
        RecipeRegistry.meltingRecipes.add(new ItemMeltingRecipe(Ingredient.func_193367_a((Item)Items.field_185164_cV), new FluidStack(boiling_beetroot_soup, 50)));
        RecipeRegistry.meltingRecipes.add(new ItemMeltingRecipe(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{smallFern}), new FluidStack(boiling_verdigris, 50)));
        RecipeRegistry.meltingRecipes.add(new ItemMeltingRecipe(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{bigFern}), new FluidStack(boiling_verdigris, 100)));
        RecipeRegistry.mixingRecipes.add(new FluidMixingRecipe(new FluidStack[]{new FluidStack(ale, 4), FluidRegistry.getFluidStack((String)"lava", (int)1)}, new FluidStack(inner_fire, 4)));
        stillRecipes.add(new RecipeStill(new FluidStack(boiling_wort, 1), Ingredient.field_193370_a, 0, new FluidStack(ale, 1)));
        stillRecipes.add(new RecipeStill(new FluidStack(boiling_potato_juice, 3), Ingredient.field_193370_a, 0, new FluidStack(vodka, 2)));
        stillRecipes.add(new RecipeStill(new FluidStack(vodka, 1), Ingredient.func_193367_a((Item)Items.field_151126_ay), 1, new FluidStack(snowpoff, 1)));
        stillRecipes.add(new RecipeStill(new FluidStack(boiling_verdigris, 1), Ingredient.func_193367_a((Item)Items.field_151102_aT), 0, new FluidStack(absinthe, 1)));
        stillRecipes.add(new RecipeStill(null, (Ingredient)new OreIngredient("logWood"), 1, new FluidStack(methanol, 1)));
        ArrayList<Fluid> allSoups = new ArrayList<Fluid>();
        allSoups.add(boiling_beetroot_soup);
        ArrayList<Fluid> allAlcohols = new ArrayList<Fluid>();
        allAlcohols.add(ale);
        allAlcohols.add(vodka);
        allAlcohols.add(inner_fire);
        allAlcohols.add(umber_ale);
        allAlcohols.add(methanol);
        allAlcohols.add(absinthe);
        allAlcohols.add(snowpoff);
        ArrayList<Fluid> allDrinks = new ArrayList<Fluid>(allAlcohols);
        allDrinks.addAll(allSoups);
        allDrinks.add(boiling_verdigris);
        stillCatalysts.add(new CatalystInfo(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{smallFern}), 250));
        stillCatalysts.add(new CatalystInfo(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{bigFern}), 500));
        stillCatalysts.add(new CatalystInfo((Ingredient)new OreIngredient("sugar"), 100));
        stillCatalysts.add(new CatalystInfo(Ingredient.func_193367_a((Item)Items.field_151126_ay), 250));
        stillCatalysts.add(new CatalystInfo((Ingredient)new OreIngredient("logWood"), 750));
        stillCatalysts.add(new CatalystInfo(Ingredient.func_193367_a((Item)Registry.ESSENCE), 1000));
        stillRecipes.add(new RecipeStillDoubleDistillation(allAlcohols, Ingredient.field_193370_a, 0));
        stillRecipes.add(new RecipeStillModifier(allAlcohols, Ingredient.func_193367_a((Item)Items.field_151073_bk), 1){

            @Override
            public void modifyOutput(TileEntityStillBase tile, FluidStack output) {
                NBTTagCompound compound = FluidUtil.createModifiers(output);
                float lifedrinker = this.getModifierOrDefault("lifedrinker", compound, output);
                float toxicity = this.getModifierOrDefault("toxicity", compound, output);
                compound.func_74776_a("toxicity", toxicity + 10.0f);
                if (lifedrinker < 18000.0f) {
                    compound.func_74776_a("lifedrinker", Math.min((lifedrinker + 600.0f) * 1.6f, 18000.0f));
                }
            }

            @Override
            public void modifyTooltip(List<String> tooltip) {
                super.modifyTooltip(tooltip);
                tooltip.add(tooltip.size() - 1, TextFormatting.GREEN + Translator.translateToLocal((String)"distilling.effect.lifedrinker"));
                tooltip.add(tooltip.size() - 1, TextFormatting.RED + Translator.translateToLocalFormatted((String)"distilling.effect.add", (Object[])new Object[]{Translator.translateToLocal((String)"distilling.modifier.toxicity.name"), 10}));
            }
        });
        stillRecipes.add(new RecipeStillModifier(allAlcohols, Ingredient.func_193367_a((Item)Items.field_151150_bK), 1){

            @Override
            public void modifyOutput(TileEntityStillBase tile, FluidStack output) {
                NBTTagCompound compound = FluidUtil.createModifiers(output);
                float steadfast = this.getModifierOrDefault("steadfast", compound, output);
                if (steadfast < 18000.0f) {
                    compound.func_74776_a("steadfast", Math.min((steadfast + 600.0f) * 1.6f, 18000.0f));
                }
            }

            @Override
            public void modifyTooltip(List<String> tooltip) {
                super.modifyTooltip(tooltip);
                tooltip.add(tooltip.size() - 1, TextFormatting.GREEN + Translator.translateToLocal((String)"distilling.effect.steadfast"));
            }
        });
        stillRecipes.add(new RecipeStillModifier(allAlcohols, (Ingredient)new OreIngredient("dustRedstone"), 1){

            @Override
            public void modifyOutput(TileEntityStillBase tile, FluidStack output) {
                NBTTagCompound compound = FluidUtil.createModifiers(output);
                float duration = this.getModifierOrDefault("duration", compound, output);
                float toxicity = this.getModifierOrDefault("toxicity", compound, output);
                compound.func_74776_a("toxicity", toxicity + 5.0f);
                if (duration < 2.5f) {
                    compound.func_74776_a("duration", Math.min(duration + 0.5f, 2.5f));
                }
            }

            @Override
            public void modifyTooltip(List<String> tooltip) {
                super.modifyTooltip(tooltip);
                tooltip.add(tooltip.size() - 1, TextFormatting.BLUE + Translator.translateToLocalFormatted((String)"distilling.effect.add_percent", (Object[])new Object[]{Translator.translateToLocal((String)"distilling.modifier.duration.name"), 50}));
                tooltip.add(tooltip.size() - 1, TextFormatting.RED + Translator.translateToLocalFormatted((String)"distilling.effect.add", (Object[])new Object[]{Translator.translateToLocal((String)"distilling.modifier.toxicity.name"), 5}));
            }
        });
        stillRecipes.add(new RecipeStillModifier(allDrinks, (Ingredient)new OreIngredient("dustPrismarine"), 1){

            @Override
            public void modifyOutput(TileEntityStillBase tile, FluidStack output) {
                NBTTagCompound compound = FluidUtil.createModifiers(output);
                float toxicity = this.getModifierOrDefault("toxicity", compound, output);
                if (toxicity > 0.0f) {
                    compound.func_74776_a("toxicity", Math.max(toxicity * 0.8f - 20.0f, 0.0f));
                }
            }

            @Override
            public void modifyTooltip(List<String> tooltip) {
                super.modifyTooltip(tooltip);
                tooltip.add(tooltip.size() - 1, TextFormatting.BLUE + Translator.translateToLocalFormatted((String)"distilling.effect.sub_percent", (Object[])new Object[]{Translator.translateToLocal((String)"distilling.modifier.toxicity.name"), 20}));
                tooltip.add(tooltip.size() - 1, TextFormatting.BLUE + Translator.translateToLocalFormatted((String)"distilling.effect.sub", (Object[])new Object[]{Translator.translateToLocal((String)"distilling.modifier.toxicity.name"), 20}));
            }
        });
        stillRecipes.add(new RecipeStillModifier(allDrinks, Ingredient.func_193367_a((Item)Items.field_151071_bq), 1){

            @Override
            public void modifyOutput(TileEntityStillBase tile, FluidStack output) {
                NBTTagCompound compound = FluidUtil.createModifiers(output);
            }

            @Override
            public void modifyTooltip(List<String> tooltip) {
                super.modifyTooltip(tooltip);
                tooltip.add(tooltip.size() - 1, TextFormatting.RED + Translator.translateToLocalFormatted((String)"distilling.effect.sub_percent", (Object[])new Object[]{Translator.translateToLocal((String)"distilling.modifier.toxicity.name"), 20}));
            }
        });
        stillRecipes.add(new RecipeStillModifier(allDrinks, (Ingredient)new OreIngredient("cropNetherWart"), 1){

            @Override
            public void modifyOutput(TileEntityStillBase tile, FluidStack output) {
                NBTTagCompound compound = FluidUtil.createModifiers(output);
                float health = this.getModifierOrDefault("health", compound, output);
                float hunger = this.getModifierOrDefault("hunger", compound, output);
                compound.func_74776_a("health", health + 4.0f);
                compound.func_74776_a("hunger", hunger - 3.0f);
            }

            @Override
            public void modifyTooltip(List<String> tooltip) {
                super.modifyTooltip(tooltip);
                tooltip.add(tooltip.size() - 1, TextFormatting.BLUE + Translator.translateToLocalFormatted((String)"distilling.effect.add", (Object[])new Object[]{Translator.translateToLocal((String)"distilling.modifier.health.name"), 4}));
                tooltip.add(tooltip.size() - 1, TextFormatting.BLUE + Translator.translateToLocalFormatted((String)"distilling.effect.sub", (Object[])new Object[]{Translator.translateToLocal((String)"distilling.modifier.hunger.name"), 3}));
            }
        });
        stillRecipes.add(new RecipeStillModifier(allDrinks, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Blocks.field_150432_aD)}), 1){

            @Override
            public void modifyOutput(TileEntityStillBase tile, FluidStack output) {
                NBTTagCompound compound = FluidUtil.createModifiers(output);
                float heat = this.getModifierOrDefault("heat", compound, output);
                if (heat > 200.0f) {
                    compound.func_74776_a("heat", Math.max(heat * 0.5f, 200.0f));
                }
            }

            @Override
            public void modifyTooltip(List<String> tooltip) {
                super.modifyTooltip(tooltip);
                tooltip.add(tooltip.size() - 1, TextFormatting.GREEN + Translator.translateToLocalFormatted((String)"distilling.effect.sub_percent", (Object[])new Object[]{Translator.translateToLocal((String)"distilling.modifier.heat.name"), 50}));
            }
        });
        stillRecipes.add(new RecipeStillModifierFood(allSoups, (Ingredient)new OreIngredient("cropPotato"), 1, 2, 0.3f));
        stillRecipes.add(new RecipeStillModifierFood(allSoups, (Ingredient)new OreIngredient("cropCarrot"), 1, 1, 0.2f));
        stillRecipes.add(new RecipeStillModifierFood(allSoups, (Ingredient)new OreIngredient("cropWheat"), 1, 4, 0.6f){

            @Override
            public void modifyOutput(TileEntityStillBase tile, FluidStack output) {
                super.modifyOutput(tile, output);
                NBTTagCompound compound = FluidUtil.createModifiers(output);
                float viscosity = this.getModifierOrDefault("viscosity", compound, output);
                compound.func_74776_a("viscosity", viscosity + 1000.0f);
            }

            @Override
            public void modifyTooltip(List<String> tooltip) {
                super.modifyTooltip(tooltip);
                tooltip.add(tooltip.size() - 1, TextFormatting.GREEN + Translator.translateToLocal((String)"distilling.effect.thick_soup"));
            }
        });
    }

    public static void addAlchemicalMixingRecipe(FluidStack output, FluidStack[] input, AspectList.AspectRangeList aspects) {
        aspects.fixMathematicalError();
        aspects.setSeedOffset(alchemicalMixingRecipes.size());
        alchemicalMixingRecipes.add(new RecipeAlchemicalMixer(input, output, aspects));
    }

    public static RecipeAlchemicalMixer getAlchemicalMixingRecipe(ArrayList<FluidStack> fluids) {
        RecipeAlchemicalMixer matchedRecipe = null;
        for (RecipeAlchemicalMixer recipe : alchemicalMixingRecipes) {
            if (!recipe.matches(fluids) || matchedRecipe != null && recipe.inputs.size() <= matchedRecipe.inputs.size()) continue;
            matchedRecipe = recipe;
        }
        return matchedRecipe;
    }

    public static RecipeStill getStillRecipe(TileEntityStillBase tile, FluidStack stack, ItemStack catalyst) {
        RecipeStill matchedRecipe = null;
        for (RecipeStill recipe : stillRecipes) {
            if (!recipe.matches(tile, stack, catalyst) || matchedRecipe != null && matchedRecipe.input != null && !matchedRecipe.catalystInput.apply(ItemStack.field_190927_a)) continue;
            matchedRecipe = recipe;
        }
        return matchedRecipe;
    }

    public static int getStillCatalyst(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        CatalystInfo matchedCatalyst = stillCatalysts.stream().filter(catalyst -> catalyst.matches(stack)).findFirst().orElse(null);
        return matchedCatalyst == null ? 1000 : matchedCatalyst.getAmount(stack);
    }
}

