/*
 * Decompiled with CFR 0.152.
 */
package soot.recipe;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import mezz.jei.util.Translator;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import soot.Registry;
import soot.compat.jei.ExtraRecipeInfo;
import soot.recipe.RecipeStillModifier;
import soot.tile.TileEntityStillBase;
import soot.util.FluidUtil;
import teamroots.embers.api.upgrades.UpgradeUtil;

public class RecipeStillDoubleDistillation
extends RecipeStillModifier {
    public static final String TAG_DOUBLE_DISTILL = "can_double_distill";

    public RecipeStillDoubleDistillation(Collection<Fluid> validFluids, Ingredient catalystInput, int catalystConsumed) {
        super(validFluids, catalystInput, catalystConsumed);
    }

    @Override
    public boolean matches(TileEntityStillBase tile, FluidStack stack, ItemStack catalyst) {
        boolean canDoubleDistill = tile == null || UpgradeUtil.getOtherParameter((TileEntity)tile, (String)TAG_DOUBLE_DISTILL, (boolean)false, tile.upgrades);
        return canDoubleDistill && super.matches(tile, stack, catalyst);
    }

    @Override
    public int getInputConsumed() {
        return 3;
    }

    @Override
    public void modifyOutput(TileEntityStillBase tile, FluidStack output) {
        NBTTagCompound compound = FluidUtil.createModifiers(output);
        output.amount = 2;
        float concentration = this.getModifierOrDefault("concentration", compound, output);
        float volume = this.getModifierOrDefault("volume", compound, output);
        if (concentration < 120.0f) {
            compound.func_74776_a("concentration", Math.min((concentration + 10.0f) * 1.8f, 120.0f));
        }
        compound.func_74776_a("volume", volume * 1.1f);
    }

    @Override
    public void modifyTooltip(List<String> tooltip) {
        super.modifyTooltip(tooltip);
        tooltip.add(tooltip.size() - 1, TextFormatting.BLUE + Translator.translateToLocalFormatted((String)"distilling.effect.add", (Object[])new Object[]{Translator.translateToLocal((String)"distilling.modifier.concentration.name"), 10}));
        tooltip.add(tooltip.size() - 1, TextFormatting.BLUE + Translator.translateToLocalFormatted((String)"distilling.effect.add_percent", (Object[])new Object[]{Translator.translateToLocal((String)"distilling.modifier.concentration.name"), 80}));
        tooltip.add(tooltip.size() - 1, TextFormatting.RED + Translator.translateToLocalFormatted((String)"distilling.effect.add_percent", (Object[])new Object[]{Translator.translateToLocal((String)"distilling.modifier.volume.name"), 10}));
        tooltip.add(tooltip.size() - 1, TextFormatting.RED + Translator.translateToLocalFormatted((String)"distilling.effect.loss", (Object[])new Object[]{33}));
    }

    @Override
    public List<ExtraRecipeInfo> getExtraInfo() {
        return Lists.newArrayList((Object[])new ExtraRecipeInfo[]{new ExtraRecipeInfo(Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Block)Registry.DISTILLATION_PIPE)})){

            @Override
            public void modifyTooltip(List<String> strings) {
                strings.clear();
                strings.add(Translator.translateToLocalFormatted((String)"distilling.effect.double_distillation", (Object[])new Object[0]));
                strings.add(Translator.translateToLocalFormatted((String)"distilling.effect.double_distillation.desc", (Object[])new Object[0]));
            }
        }});
    }
}

