/*
 * Decompiled with CFR 0.152.
 */
package soot.tile;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import soot.block.BlockScale;

public class TileEntityScale
extends TileEntity
implements ITickable {
    int weightDifference = 0;

    public int getWeightDifference() {
        return this.weightDifference;
    }

    public void func_73660_a() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() instanceof BlockScale) {
            int lastWeightDifference = this.weightDifference;
            this.weightDifference = 0;
            BlockScale block = (BlockScale)state.func_177230_c();
            EnumFacing.Axis axis = block.getAxis(state);
            EnumFacing left = EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.NEGATIVE, (EnumFacing.Axis)axis);
            EnumFacing right = EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.POSITIVE, (EnumFacing.Axis)axis);
            TileEntity leftTile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(left));
            TileEntity rightTile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(right));
            if (leftTile != null && rightTile != null) {
                if (leftTile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, right) && rightTile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, left)) {
                    this.weightDifference = this.compareItemHandlers((IItemHandler)leftTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, right), (IItemHandler)rightTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, left));
                }
                if (leftTile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, right) && rightTile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, left)) {
                    this.weightDifference = this.compareFluidHandlers((IFluidHandler)leftTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, right), (IFluidHandler)rightTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, left));
                }
            }
            if (this.weightDifference != lastWeightDifference) {
                this.field_145850_b.func_175685_c(this.field_174879_c.func_177977_b(), (Block)block, false);
            }
        }
    }

    private int compareFluidHandlers(IFluidHandler left, IFluidHandler right) {
        FluidStack leftFluid = left.drain(Integer.MAX_VALUE, false);
        FluidStack rightFluid = right.drain(Integer.MAX_VALUE, false);
        return Integer.compare(leftFluid != null ? leftFluid.amount : 0, rightFluid != null ? rightFluid.amount : 0);
    }

    private int compareItemHandlers(IItemHandler left, IItemHandler right) {
        int i;
        int leftItems = 0;
        int rightItems = 0;
        for (i = 0; i < left.getSlots(); ++i) {
            leftItems += left.getStackInSlot(i).func_190916_E();
        }
        for (i = 0; i < right.getSlots(); ++i) {
            rightItems += right.getStackInSlot(i).func_190916_E();
        }
        return Integer.compare(leftItems, rightItems);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }
}

