/*
 * Decompiled with CFR 0.152.
 */
package soot.upgrade;

import java.util.List;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import soot.SoundEvents;
import soot.network.PacketHandler;
import soot.network.message.MessageMixerBlastFX;
import soot.network.message.MessageMixerFailFX;
import soot.recipe.CraftingRegistry;
import soot.recipe.RecipeAlchemicalMixer;
import soot.tile.TileEntityAlchemyGlobe;
import teamroots.embers.api.alchemy.AlchemyResult;
import teamroots.embers.api.event.MachineRecipeEvent;
import teamroots.embers.api.event.UpgradeEvent;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.recipe.FluidMixingRecipe;
import teamroots.embers.tileentity.TileEntityMixerBottom;
import teamroots.embers.tileentity.TileEntityMixerTop;
import teamroots.embers.util.DefaultUpgradeProvider;

public class UpgradeAlchemyGlobe
extends DefaultUpgradeProvider {
    public static final int STARTUP_TIME = 200;
    public static final double STARTUP_COST = 15.0;
    public static final double FAILURE_COST = 6000.0;
    public static final double COST_MULTIPLIER = 20.0;
    Status status = Status.Idle;
    int statusTick;
    RecipeAlchemicalMixer currentRecipe;

    public UpgradeAlchemyGlobe(TileEntity tile) {
        super("alchemy_globe", tile);
    }

    public int getStatusTick() {
        return this.statusTick;
    }

    public void setStatus(Status status) {
        this.setStatus(status, 0);
    }

    public void setStatus(Status status, int tick) {
        this.status = status;
        this.statusTick = tick;
    }

    public Status getStatus() {
        return this.status;
    }

    public int getLimit(TileEntity tile) {
        return 1;
    }

    private boolean canCraft() {
        switch (this.status) {
            default: {
                return false;
            }
            case Crafting: 
            case Success: 
        }
        return true;
    }

    public double transformEmberConsumption(TileEntity tile, double ember) {
        return ember * 20.0;
    }

    public boolean doTick(TileEntity tile, List<IUpgradeProvider> upgrades) {
        ++this.statusTick;
        if (!this.tile.func_145831_w().field_72995_K) {
            switch (this.status) {
                case Idle: 
                case Crafting: 
                case Success: {
                    break;
                }
                case PreStarting: {
                    this.setStatus(Status.Starting);
                    break;
                }
                case Starting: {
                    if (tile instanceof TileEntityMixerBottom) {
                        TileEntityMixerBottom bottom = (TileEntityMixerBottom)tile;
                        TileEntityMixerTop top = (TileEntityMixerTop)bottom.func_145831_w().func_175625_s(bottom.func_174877_v().func_177984_a());
                        double consumed = top.capability.removeAmount(15.0, true);
                        if (consumed < 15.0) {
                            this.setStatus(Status.Idle);
                        }
                    }
                    if (this.statusTick < 200) break;
                    BlockPos pos = this.tile.func_174877_v();
                    PacketHandler.INSTANCE.sendToAll((IMessage)new MessageMixerBlastFX((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0, 4.5));
                    this.setStatus(Status.Crafting);
                    break;
                }
                case Failure: {
                    if (this.statusTick < 0) break;
                    this.setStatus(Status.Idle);
                }
            }
        }
        return false;
    }

    public boolean doWork(TileEntity tile, List<IUpgradeProvider> upgrades) {
        if (!(this.tile instanceof TileEntityAlchemyGlobe)) {
            return false;
        }
        if (!this.canCraft()) {
            return true;
        }
        TileEntityAlchemyGlobe globe = (TileEntityAlchemyGlobe)this.tile;
        World world = globe.func_145831_w();
        if (!world.field_72995_K && tile instanceof TileEntityMixerBottom) {
            TileEntityMixerBottom bottom = (TileEntityMixerBottom)tile;
            TileEntityMixerTop top = (TileEntityMixerTop)world.func_175625_s(bottom.func_174877_v().func_177984_a());
            if (this.currentRecipe != null) {
                AlchemyResult result = this.currentRecipe.matchAshes(globe.getAspects(), world);
                if (result.getAccuracy() == 1.0) {
                    this.setStatus(Status.Success);
                } else {
                    if (result.areAllPresent()) {
                        this.ejectFailure(world, top.func_174877_v(), result.createFailure(), EnumFacing.field_176754_o);
                        bottom.consumeFluids((FluidMixingRecipe)this.currentRecipe);
                        top.capability.removeAmount(6000.0, true);
                        globe.consumeAsh();
                        this.setStatus(Status.Failure, -(world.field_73012_v.nextInt(100) + 200));
                        BlockPos pos = globe.func_174877_v();
                        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageMixerBlastFX((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 8, 0.8));
                        return true;
                    }
                    this.setStatus(Status.Failure, -(world.field_73012_v.nextInt(100) + 200));
                    return true;
                }
            }
        }
        return false;
    }

    public void throwEvent(TileEntity tile, UpgradeEvent event) {
        if (!(this.tile instanceof TileEntityAlchemyGlobe)) {
            return;
        }
        if (event.getTile() instanceof TileEntityMixerBottom) {
            TileEntityMixerBottom bottom = (TileEntityMixerBottom)event.getTile();
            if (event instanceof MachineRecipeEvent) {
                MachineRecipeEvent recipeEvent = (MachineRecipeEvent)event;
                if (!this.canCraft()) {
                    recipeEvent.setRecipe(null);
                } else {
                    this.currentRecipe = CraftingRegistry.getAlchemicalMixingRecipe(bottom.getFluids());
                    if (this.currentRecipe == null) {
                        this.setStatus(Status.Crafting);
                    }
                    recipeEvent.setRecipe((Object)this.currentRecipe);
                }
            }
        }
    }

    public FluidStack transformOutput(TileEntity tile, FluidStack output) {
        if (this.status == Status.Success) {
            return output;
        }
        return null;
    }

    public void ejectFailure(World world, BlockPos pos, ItemStack failure, EnumFacing[] directions) {
        int ioff = 0;
        for (int i = 0; i < directions.length; ++i) {
            EnumFacing direction = directions[(i + ioff) % directions.length];
            BlockPos ejectPos = pos.func_177972_a(direction);
            IBlockState state = world.func_180495_p(ejectPos);
            if (state.func_193401_d((IBlockAccess)world, ejectPos, direction.func_176734_d()) != BlockFaceShape.UNDEFINED) continue;
            this.ejectFailure(world, pos, failure, direction);
            return;
        }
        this.ejectFailure(world, pos, failure, EnumFacing.UP);
    }

    public void ejectFailure(World world, BlockPos pos, ItemStack failure, EnumFacing direction) {
        float xEject = direction.func_82601_c();
        float zEject = direction.func_82599_e();
        float xOff = world.field_73012_v.nextFloat() * 0.05f + 0.475f + xEject * 0.7f;
        float yOff = 0.5f;
        float zOff = world.field_73012_v.nextFloat() * 0.05f + 0.475f + zEject * 0.7f;
        world.func_184148_a(null, (double)((float)pos.func_177958_n() + xOff), (double)((float)pos.func_177956_o() + yOff), (double)((float)pos.func_177952_p() + zOff), SoundEvents.ALCHEMICAL_MIXER_WASTE, SoundCategory.BLOCKS, 1.0f, 1.0f);
        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageMixerFailFX((float)pos.func_177958_n() + xOff, (float)pos.func_177956_o() + yOff, (float)pos.func_177952_p() + zOff, direction));
        EntityItem item = new EntityItem(world, (double)((float)pos.func_177958_n() + xOff), (double)((float)pos.func_177956_o() + yOff - 0.4f), (double)((float)pos.func_177952_p() + zOff), failure);
        item.field_70159_w = xEject * 0.1f;
        item.field_70181_x = 0.0;
        item.field_70179_y = zEject * 0.1f;
        item.func_174869_p();
        world.func_72838_d((Entity)item);
    }

    public static enum Status {
        Idle,
        PreStarting,
        Starting,
        Crafting,
        Success,
        Failure;

    }
}

