/*
 * Decompiled with CFR 0.152.
 */
package soot.upgrade;

import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import soot.recipe.CraftingRegistry;
import soot.recipe.RecipeStill;
import soot.recipe.RecipeStillModifier;
import soot.tile.TileEntityStillBase;
import soot.tile.TileEntityStillTip;
import teamroots.embers.Embers;
import teamroots.embers.api.event.DialInformationEvent;
import teamroots.embers.api.event.UpgradeEvent;
import teamroots.embers.util.DefaultUpgradeProvider;

public class UpgradeDistillationPipe
extends DefaultUpgradeProvider {
    public UpgradeDistillationPipe(TileEntity tile) {
        super("distillation_pipe", tile);
    }

    public double getSpeed(TileEntity tile, double speed) {
        FluidStack inputStack;
        RecipeStill recipe;
        TileEntityStillBase base;
        TileEntityStillTip tip;
        if (tile instanceof TileEntityStillBase && (tip = (base = (TileEntityStillBase)tile).getTip()) != null && this.isDistillationRecipe(recipe = CraftingRegistry.getStillRecipe(base, inputStack = base.tank.getFluid(), tip.getCurrentCatalyst()))) {
            return speed + 0.5;
        }
        return speed;
    }

    private boolean isDistillationRecipe(RecipeStill recipe) {
        return !(recipe instanceof RecipeStillModifier) || recipe.catalystInput.apply(ItemStack.field_190927_a);
    }

    public boolean getOtherParameter(TileEntity tile, String type, boolean value) {
        if (type.equals("can_double_distill")) {
            return true;
        }
        return value;
    }

    public void throwEvent(TileEntity tile, UpgradeEvent event) {
        DialInformationEvent dialEvent;
        if (event instanceof DialInformationEvent && "alchemy".equals((dialEvent = (DialInformationEvent)event).getDialType())) {
            dialEvent.getInformation().add(Embers.proxy.formatLocalize("embers.tooltip.upgrade.distillation_pipe", new Object[0]));
        }
    }
}

