/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.awt.Color;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import soot.particle.ParticleUtilSoot;
import soot.util.MiscUtil;

public class Attributes {
    public static final IAttribute PHYSICAL_DAMAGE_RATE = new RangedAttribute(null, "generic.physicalDamageRate", 1.0, 0.0, 2048.0);
    public static final IAttribute FIRE_DAMAGE_RATE = new RangedAttribute(null, "generic.fireDamageRate", 1.0, 0.0, 2048.0);
    public static final IAttribute FIRE_ASPECT = new RangedAttribute(null, "generic.fireAspect", 0.0, 0.0, 72000.0);
    public static final IAttribute BAREHANDED_POWER = new RangedAttribute(null, "generic.barehandedPower", 1.0, 0.0, 2048.0);
    public static final IAttribute WITCHBURN = new RangedAttribute(null, "generic.witchburn", 0.0, 0.0, Double.MAX_VALUE).func_111112_a(true);
    public static final IAttribute ATTRACTION = new RangedAttribute(null, "generic.attraction", 0.0, 0.0, Double.MAX_VALUE).func_111112_a(true);
    public static final IAttribute ATTRACTION_GENERATION = new RangedAttribute(null, "generic.attraction_generation", 0.0, 0.0, Double.MAX_VALUE).func_111112_a(true);
    public static final double ATTRACTION_STACK = 100.0;
    private static final Random random = new Random();

    @SubscribeEvent
    public static void onEntityConstructEvent(EntityEvent.EntityConstructing event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_110140_aT().func_111150_b(PHYSICAL_DAMAGE_RATE);
            ((EntityLivingBase)entity).func_110140_aT().func_111150_b(FIRE_DAMAGE_RATE);
            ((EntityLivingBase)entity).func_110140_aT().func_111150_b(FIRE_ASPECT);
            ((EntityLivingBase)entity).func_110140_aT().func_111150_b(BAREHANDED_POWER);
            ((EntityLivingBase)entity).func_110140_aT().func_111150_b(WITCHBURN);
            ((EntityLivingBase)entity).func_110140_aT().func_111150_b(ATTRACTION);
            ((EntityLivingBase)entity).func_110140_aT().func_111150_b(ATTRACTION_GENERATION);
        }
    }

    @SubscribeEvent
    public static void onUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        Entity entity = event.getEntity();
        IAttributeInstance attraction = ((EntityLivingBase)entity).func_110148_a(ATTRACTION);
        double value = attraction.func_111126_e();
        if (value > 0.0 && entity.field_70170_p.field_72995_K) {
            double size = entity.func_184177_bl().func_72320_b();
            double height = 0.5 * (double)entity.func_70047_e() + 0.2;
            double currentStack = value % 100.0 / 100.0;
            size = size * size * size;
            double angleSpread = 0.3;
            double yaw = -Math.toRadians(((EntityLivingBase)entity).field_70759_as + 180.0f);
            int i = 1;
            while ((double)i < value / 100.0) {
                ParticleUtilSoot.spawnParticleCrystal(entity, 0.0, height, 0.0, 0.0, 0.0, 0.0, (float)(yaw + (random.nextDouble() - 0.5) * Math.PI * angleSpread), (float)((random.nextDouble() - 0.5) * Math.PI * angleSpread), Color.WHITE, (float)(size * random.nextDouble() * 0.1), 20);
                ++i;
            }
            ParticleUtilSoot.spawnParticleCrystal(entity, 0.0, height, 0.0, 0.0, 0.0, 0.0, (float)(yaw + (random.nextDouble() - 0.5) * Math.PI * angleSpread), (float)((random.nextDouble() - 0.5) * Math.PI * angleSpread), Color.WHITE, (float)(size * 0.1 * currentStack), 20);
        }
    }

    @SubscribeEvent
    public static void onStrikeEvent(LivingHurtEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        DamageSource damageSource = event.getSource();
        float damage = event.getAmount();
        EntityLivingBase attacker = null;
        if (damageSource.func_76364_f() instanceof EntityLivingBase) {
            attacker = (EntityLivingBase)damageSource.func_76364_f();
        } else if (damageSource.func_76346_g() instanceof EntityLivingBase) {
            attacker = (EntityLivingBase)damageSource.func_76346_g();
        }
        if (entity != null && attacker != null) {
            int fire_aspect = (int)entity.func_110148_a(FIRE_ASPECT).func_111126_e();
            if (MiscUtil.isBarehandedDamage(damageSource, attacker)) {
                damage = (float)((double)damage * entity.func_110148_a(BAREHANDED_POWER).func_111126_e());
            }
            if (fire_aspect > 0) {
                entity.func_70015_d(fire_aspect);
            }
        }
        event.setAmount(damage);
    }

    @SubscribeEvent
    public static void onHurtEvent(LivingHurtEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        DamageSource damageSource = event.getSource();
        float damage = event.getAmount();
        if (entity != null) {
            IAttributeInstance damageRate = null;
            if (MiscUtil.isPhysicalDamage(damageSource)) {
                damageRate = entity.func_110148_a(PHYSICAL_DAMAGE_RATE);
            }
            if (damageSource.func_76347_k()) {
                damageRate = entity.func_110148_a(FIRE_DAMAGE_RATE);
            }
            if (damageRate != null) {
                damage = (float)((double)damage * damageRate.func_111126_e());
            }
        }
        event.setAmount(damage);
    }

    public static boolean isAttracted(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            IAttributeInstance attraction = ((EntityLivingBase)entity).func_110148_a(ATTRACTION);
            return attraction.func_111126_e() > 0.0;
        }
        return false;
    }

    public static boolean isGenerating(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            IAttributeInstance attraction = ((EntityLivingBase)entity).func_110148_a(ATTRACTION_GENERATION);
            return attraction.func_111126_e() > 0.0;
        }
        return false;
    }

    public static void resetAttraction(Entity entity, int stacks) {
        if (entity instanceof EntityLivingBase) {
            IAttributeInstance attraction = ((EntityLivingBase)entity).func_110148_a(ATTRACTION);
            double amount = attraction.func_111125_b();
            amount -= amount % 100.0;
            attraction.func_111128_a(Math.max(amount -= 100.0 * (double)stacks, 0.0));
        }
    }

    public static void increaseAttraction(Entity entity, double amount) {
        if (entity instanceof EntityLivingBase) {
            IAttributeInstance attraction = ((EntityLivingBase)entity).func_110148_a(ATTRACTION);
            attraction.func_111128_a(attraction.func_111125_b() + amount);
        }
    }

    public static void increaseGeneration(Entity entity, double amount) {
        if (entity instanceof EntityLivingBase) {
            IAttributeInstance attraction = ((EntityLivingBase)entity).func_110148_a(ATTRACTION_GENERATION);
            attraction.func_111128_a(attraction.func_111125_b() + amount);
        }
    }

    public static void decreaseGeneration(Entity entity, double amount) {
        if (entity instanceof EntityLivingBase) {
            IAttributeInstance attraction = ((EntityLivingBase)entity).func_110148_a(ATTRACTION_GENERATION);
            attraction.func_111128_a(Math.max(attraction.func_111125_b() - amount, 0.0));
        }
    }
}

