/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import soot.Registry;

public class MiscUtil {
    @SideOnly(value=Side.CLIENT)
    public static void addPotionEffectTooltip(List<PotionEffect> list, List<String> lores, float durationFactor) {
        ArrayList attributeModifiers = Lists.newArrayList();
        if (list.isEmpty()) {
            String s = I18n.func_74838_a((String)"effect.none").trim();
            lores.add(TextFormatting.GRAY + s);
        } else {
            for (PotionEffect potioneffect : list) {
                String s1 = I18n.func_74838_a((String)potioneffect.func_76453_d()).trim();
                Potion potion = potioneffect.func_188419_a();
                Map map = potion.func_111186_k();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.func_111166_b(), potion.func_111183_a(potioneffect.func_76458_c(), attributemodifier), attributemodifier.func_111169_c());
                        attributeModifiers.add(new Tuple((Object)((IAttribute)entry.getKey()).func_111108_a(), (Object)attributemodifier1));
                    }
                }
                if (potioneffect.func_76458_c() > 0) {
                    s1 = s1 + " " + I18n.func_74838_a((String)("potion.potency." + potioneffect.func_76458_c())).trim();
                }
                if (potioneffect.func_76459_b() > 20) {
                    s1 = s1 + " (" + Potion.func_188410_a((PotionEffect)potioneffect, (float)durationFactor) + ")";
                }
                if (potion.func_76398_f()) {
                    lores.add(TextFormatting.RED + s1);
                    continue;
                }
                lores.add(TextFormatting.BLUE + s1);
            }
        }
        if (!attributeModifiers.isEmpty()) {
            lores.add("");
            lores.add(TextFormatting.DARK_PURPLE + I18n.func_74838_a((String)"potion.whenDrank"));
            for (Tuple tuple : attributeModifiers) {
                AttributeModifier attributemodifier2 = (AttributeModifier)tuple.func_76340_b();
                double d0 = attributemodifier2.func_111164_d();
                double d1 = attributemodifier2.func_111169_c() != 1 && attributemodifier2.func_111169_c() != 2 ? attributemodifier2.func_111164_d() : attributemodifier2.func_111164_d() * 100.0;
                if (d0 > 0.0) {
                    lores.add(TextFormatting.BLUE + I18n.func_74837_a((String)("attribute.modifier.plus." + attributemodifier2.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1), I18n.func_74838_a((String)("attribute.name." + (String)tuple.func_76341_a()))}));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                lores.add(TextFormatting.RED + I18n.func_74837_a((String)("attribute.modifier.take." + attributemodifier2.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), I18n.func_74838_a((String)("attribute.name." + (String)tuple.func_76341_a()))}));
            }
        }
    }

    public static void damageWithoutInvulnerability(Entity entity, DamageSource source, float amount) {
        if (entity.func_70097_a(source, amount)) {
            entity.field_70172_ad = 0;
        }
    }

    public static void degradeEquipment(EntityLivingBase entity, int amt) {
        for (ItemStack armor : entity.func_184193_aE()) {
            if (!armor.func_77984_f()) continue;
            armor.func_77972_a(amt, entity);
        }
    }

    public static boolean isPhysicalDamage(DamageSource damageSource) {
        return damageSource.func_76364_f() != null && !damageSource.func_76352_a() && !damageSource.func_94541_c() && !damageSource.func_76347_k() && !damageSource.func_82725_o() && !damageSource.func_151517_h();
    }

    public static boolean isBarehandedDamage(DamageSource damageSource, EntityLivingBase attacker) {
        return attacker.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b() && MiscUtil.isPhysicalDamage(damageSource);
    }

    public static boolean isEitrDamage(DamageSource damageSource, EntityLivingBase attacker) {
        return attacker.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() == Registry.EITR && MiscUtil.isPhysicalDamage(damageSource);
    }

    public static void setLore(List<String> addedLore, NBTTagCompound compound, boolean append) {
        if (compound != null && compound.func_150297_b("display", 10)) {
            NBTTagList lore;
            NBTTagCompound display = compound.func_74775_l("display");
            if (display.func_150297_b("Lore", 9) && append) {
                lore = display.func_150295_c("Lore", 8);
            } else {
                lore = new NBTTagList();
                display.func_74782_a("Lore", (NBTBase)lore);
            }
            for (String loreString : addedLore) {
                lore.func_74742_a((NBTBase)new NBTTagString(loreString));
            }
        }
    }

    public static List<String> getLore(NBTTagCompound compound) {
        NBTTagList lore;
        NBTTagCompound display;
        ArrayList<String> addedLore = new ArrayList<String>();
        if (compound != null && compound.func_150297_b("display", 10) && (display = compound.func_74775_l("display")).func_150297_b("Lore", 9) && !(lore = display.func_150295_c("Lore", 8)).func_82582_d()) {
            for (int i = 0; i < lore.func_74745_c(); ++i) {
                addedLore.add(lore.func_150307_f(i));
            }
        }
        return addedLore;
    }

    public static Item.ToolMaterial getToolMaterial(Item item) {
        if (item instanceof ItemTool) {
            return (Item.ToolMaterial)ReflectionHelper.getPrivateValue(ItemTool.class, (Object)((ItemTool)item), (String[])new String[]{"field_77862_b", "toolMaterial"});
        }
        if (item instanceof ItemHoe) {
            return (Item.ToolMaterial)ReflectionHelper.getPrivateValue(ItemHoe.class, (Object)((ItemHoe)item), (String[])new String[]{"field_77843_a", "toolMaterial"});
        }
        if (item instanceof ItemSword) {
            return (Item.ToolMaterial)ReflectionHelper.getPrivateValue(ItemSword.class, (Object)((ItemSword)item), (String[])new String[]{"field_150933_b", "material"});
        }
        if (item instanceof ItemArmor) {
            return (Item.ToolMaterial)ReflectionHelper.getPrivateValue(ItemArmor.class, (Object)((ItemArmor)item), (String[])new String[]{"field_77878_bZ", "material"});
        }
        return null;
    }

    public static String generateFormatMatchCode(int code) {
        String formatCode = "";
        for (int i = 0; i < 4; ++i) {
            formatCode = formatCode + TextFormatting.func_175744_a((int)(code >> i * 4 & 0xF));
        }
        return formatCode + TextFormatting.RESET;
    }

    public static String generateEmptyString(String original) {
        int len = Minecraft.func_71410_x().field_71466_p.func_78256_a(original);
        String spaces = "";
        while (Minecraft.func_71410_x().field_71466_p.func_78256_a(spaces) < len) {
            spaces = spaces + " ";
        }
        return spaces;
    }

    public static Color lerpColor(Color color1, Color color2, double scale) {
        return new Color(MiscUtil.lerp(color1.getRed(), color2.getRed(), scale), MiscUtil.lerp(color1.getGreen(), color2.getGreen(), scale), MiscUtil.lerp(color1.getBlue(), color2.getBlue(), scale), MiscUtil.lerp(color1.getAlpha(), color2.getAlpha(), scale));
    }

    public static Color maxColor(Color color) {
        float multiplier = 1.0f / (float)Math.max(color.getRed(), Math.max(color.getGreen(), color.getBlue()));
        return new Color((float)color.getRed() * multiplier, (float)color.getGreen() * multiplier, (float)color.getBlue() * multiplier, (float)color.getAlpha() / 255.0f);
    }

    public static int lerp(int a, int b, double scale) {
        return (int)((double)a * (1.0 - scale) + (double)b * scale);
    }
}

