/*
 * Decompiled with CFR 0.152.
 */
package ru.flametaichou.ordinarycoins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import ru.flametaichou.ordinarycoins.ConfigHelper;
import ru.flametaichou.ordinarycoins.OrdinaryCoinsBase;
import ru.flametaichou.ordinarycoins.items.ItemCoinBronze;
import ru.flametaichou.ordinarycoins.items.ItemCoinGold;
import ru.flametaichou.ordinarycoins.items.ItemCoinPlatinum;
import ru.flametaichou.ordinarycoins.items.ItemCoinSilver;

public class OrdinaryCoinsCommands
extends CommandBase {
    private final List<String> aliases = new ArrayList<String>();

    public OrdinaryCoinsCommands() {
        this.aliases.add("coins");
    }

    @Nonnull
    public String func_71517_b() {
        return "coins";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "coins <stack/unstack/repair>";
    }

    @Nonnull
    public List<String> func_71514_a() {
        return this.aliases;
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        World world = sender.func_130014_f_();
        if (!world.field_72995_K) {
            if (args.length == 0) {
                if (ConfigHelper.repair) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("/coins <stack/unstack/repair>"));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("/coins <stack/unstack>"));
                }
                return;
            }
            if (args[0].equals("stack")) {
                if (sender instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)sender;
                    this.stackCoins(player);
                } else {
                    if (args.length < 2) {
                        System.out.println("[Ordinary Coins] Stack error: player name is not defined!");
                        return;
                    }
                    EntityPlayer player = world.func_72924_a(args[1]);
                    this.stackCoins(player);
                }
                return;
            }
            if (args[0].equals("unstack")) {
                if (sender instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)sender;
                    this.unstackCoins(player);
                } else {
                    if (args.length < 2) {
                        System.out.println("[Ordinary Coins] Unstack error: player name is not defined!");
                        return;
                    }
                    EntityPlayer player = world.func_72924_a(args[1]);
                    this.unstackCoins(player);
                }
                return;
            }
            if (args[0].equals("repair") && ConfigHelper.repair) {
                if (sender instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)sender;
                    this.repairItemInHand(player);
                } else {
                    if (args.length < 2) {
                        System.out.println("[Ordinary Coins] Repair error: player name is not defined!");
                        return;
                    }
                    EntityPlayer player = world.func_72924_a(args[1]);
                    this.repairItemInHand(player);
                }
                return;
            }
        }
    }

    private void stackCoins(EntityPlayer player) {
        InventoryPlayer inventory = player.field_71071_by;
        int countBronze = 0;
        int countSilver = 0;
        int countGold = 0;
        for (ItemStack s : inventory.field_70462_a) {
            if (s != null && s.func_77973_b() instanceof ItemCoinBronze) {
                countBronze += s.func_190916_E();
            }
            if (s != null && s.func_77973_b() instanceof ItemCoinSilver) {
                countSilver += s.func_190916_E();
            }
            if (s == null || !(s.func_77973_b() instanceof ItemCoinGold)) continue;
            countGold += s.func_190916_E();
        }
        inventory.func_174925_a((Item)OrdinaryCoinsBase.coinBronze, 0, countBronze, null);
        inventory.func_174925_a((Item)OrdinaryCoinsBase.coinSilver, 0, countSilver, null);
        inventory.func_174925_a((Item)OrdinaryCoinsBase.coinGold, 0, countGold, null);
        inventory.func_70441_a(new ItemStack((Item)OrdinaryCoinsBase.coinSilver, countBronze / ConfigHelper.coinsStackSize));
        inventory.func_70441_a(new ItemStack((Item)OrdinaryCoinsBase.coinBronze, countBronze % ConfigHelper.coinsStackSize));
        inventory.func_70441_a(new ItemStack((Item)OrdinaryCoinsBase.coinGold, countSilver / ConfigHelper.coinsStackSize));
        inventory.func_70441_a(new ItemStack((Item)OrdinaryCoinsBase.coinSilver, countSilver % ConfigHelper.coinsStackSize));
        inventory.func_70441_a(new ItemStack((Item)OrdinaryCoinsBase.coinPlatinum, countGold / ConfigHelper.coinsStackSize));
        inventory.func_70441_a(new ItemStack((Item)OrdinaryCoinsBase.coinGold, countGold % ConfigHelper.coinsStackSize));
        player.func_145747_a((ITextComponent)new TextComponentTranslation("coins.stacked", new Object[0]));
    }

    private void unstackCoins(EntityPlayer player) {
        ItemStack is;
        InventoryPlayer inventory = player.field_71071_by;
        int countPlatinum = 0;
        int countGold = 0;
        int countSilver = 0;
        for (ItemStack s : inventory.field_70462_a) {
            if (s != null && s.func_77973_b() instanceof ItemCoinPlatinum) {
                countPlatinum += s.func_190916_E();
            }
            if (s != null && s.func_77973_b() instanceof ItemCoinGold) {
                countGold += s.func_190916_E();
            }
            if (s == null || !(s.func_77973_b() instanceof ItemCoinSilver)) continue;
            countSilver += s.func_190916_E();
        }
        inventory.func_174925_a((Item)OrdinaryCoinsBase.coinPlatinum, 0, countPlatinum, null);
        inventory.func_174925_a((Item)OrdinaryCoinsBase.coinGold, 0, countGold, null);
        inventory.func_174925_a((Item)OrdinaryCoinsBase.coinSilver, 0, countSilver, null);
        if (countPlatinum > 0) {
            is = new ItemStack((Item)OrdinaryCoinsBase.coinGold, countPlatinum * ConfigHelper.coinsStackSize);
            this.spawnEntityItemInWorld(is, player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v);
        }
        if (countGold > 0) {
            is = new ItemStack((Item)OrdinaryCoinsBase.coinSilver, countGold * ConfigHelper.coinsStackSize);
            this.spawnEntityItemInWorld(is, player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v);
        }
        if (countSilver > 0) {
            is = new ItemStack((Item)OrdinaryCoinsBase.coinBronze, countSilver * ConfigHelper.coinsStackSize);
            this.spawnEntityItemInWorld(is, player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v);
        }
        player.func_145747_a((ITextComponent)new TextComponentTranslation("coins.unstacked", new Object[0]));
    }

    private void repairItemInHand(EntityPlayer player) {
        InventoryPlayer inventory = player.field_71071_by;
        Item coin = this.pickCoinFromConfig();
        int countCoins = 0;
        for (ItemStack s : inventory.field_70462_a) {
            if (s == null || s.func_77973_b() != coin) continue;
            countCoins += s.func_190916_E();
        }
        ItemStack item = player.func_184614_ca();
        if (countCoins >= ConfigHelper.repairCost) {
            if (item != null && item.func_77951_h()) {
                inventory.func_174925_a(coin, 0, ConfigHelper.repairCost, null);
                item.func_77964_b(0);
                player.func_145747_a((ITextComponent)new TextComponentTranslation("coins.repaired", new Object[0]));
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("coins.cantrepair", new Object[0]));
            }
        } else {
            switch (ConfigHelper.repairCoinType) {
                case 0: {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("coins.notenough.bronze", new Object[]{ConfigHelper.repairCost}));
                    break;
                }
                case 1: {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("coins.notenough.silver", new Object[]{ConfigHelper.repairCost}));
                    break;
                }
                case 2: {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("coins.notenough.gold", new Object[]{ConfigHelper.repairCost}));
                    break;
                }
                case 3: {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("coins.notenough.platinum", new Object[]{ConfigHelper.repairCost}));
                }
            }
        }
    }

    private void spawnEntityItemInWorld(ItemStack is, World world, Double x, Double y, Double z) {
        EntityItem loot = new EntityItem(world, x.doubleValue(), y.doubleValue(), z.doubleValue(), is);
        world.func_72838_d((Entity)loot);
    }

    private Item pickCoinFromConfig() {
        Item coin = OrdinaryCoinsBase.coinSilver;
        switch (ConfigHelper.repairCoinType) {
            case 0: {
                coin = OrdinaryCoinsBase.coinBronze;
                break;
            }
            case 1: {
                coin = OrdinaryCoinsBase.coinSilver;
                break;
            }
            case 2: {
                coin = OrdinaryCoinsBase.coinGold;
                break;
            }
            case 3: {
                coin = OrdinaryCoinsBase.coinPlatinum;
            }
        }
        return coin;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return Collections.emptyList();
    }
}

