/*
 * Decompiled with CFR 0.152.
 */
package scavenge.api.block.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.ChoiceElement;
import scavenge.api.autodoc.Elements;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.IResourceFactory;
import scavenge.api.utils.CompatState;

public abstract class BaseResourceFactory
implements IResourceFactory {
    String id;
    Map<String, CompatState> incompats = new HashMap<String, CompatState>();
    IResourceFactory.PropertyType type;

    public BaseResourceFactory(String id, IResourceFactory.PropertyType theType) {
        this.id = id;
        this.type = theType;
    }

    public void setCompatState(CompatState state) {
        this.incompats.put(this.getID(), state);
    }

    public void addIncompat(String id, CompatState state) {
        this.incompats.put(id, state);
    }

    public void addIncompats(CompatState state, String ... ids) {
        for (String key : ids) {
            this.incompats.put(key, state);
        }
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void addIncompats(BiConsumer<String, CompatState> states) {
        if (this.incompats.size() > 0) {
            this.incompats.forEach(states);
        }
    }

    @Override
    public MapElement getDocumentation() {
        MapElement element = new MapElement("");
        element.addElement(new BooleanElement("disableJEI", false, "Decides if the Condition is visible in JEI"));
        return element;
    }

    public void addDefaultOperationText(ChoiceElement element, int index) {
        element.addElement(index, Elements.MATH_OPS.copyWithID("operations"));
        element.addElement(index, new TextElement("jeiDesc", "").setDescription("The Description for the JEI plugin"));
    }

    @Override
    public IResourceFactory.PropertyType getType() {
        return this.type;
    }
}

