/*
 * Decompiled with CFR 0.152.
 */
package scavenge.core.builder.block;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceProperty;
import scavenge.api.utils.BlockEntry;
import scavenge.core.builder.block.BlockResource;
import scavenge.core.builder.block.IBlockResource;
import scavenge.core.loot.ILoot;
import scavenge.core.loot.WeightLoot;

public abstract class BlockResourceBuilder {
    String id;
    List<IResourceProperty> properties = new ArrayList<IResourceProperty>();
    HashMap<ILoot, IResourceCondition[]> conditionalLoot = new LinkedHashMap<ILoot, IResourceCondition[]>();
    List<ILoot> loots = new ArrayList<ILoot>();
    Map<String, String> messages = new HashMap<String, String>();
    int effects;
    int rightClickState = 1;
    int leftClickState = 0;
    boolean breaking = false;
    boolean placeState = false;
    boolean shouldShow = true;

    public boolean addProperty(IResourceProperty prop) {
        if (!(prop instanceof IResourceCondition) && !(prop instanceof IResourceEffect)) {
            return false;
        }
        for (IResourceProperty entry : this.properties) {
            if (entry.canCombine(prop) && prop.canCombine(entry)) continue;
            return false;
        }
        if (prop instanceof IResourceEffect) {
            ++this.effects;
        }
        this.properties.add(prop);
        return true;
    }

    public void setVisibility(boolean visible) {
        this.shouldShow = visible;
    }

    public void setLeftClickState(int type) {
        this.leftClickState = type;
    }

    public void setRightClickState(int type) {
        this.rightClickState = type;
    }

    public void setBreakingType() {
        this.leftClickState = 0;
        this.rightClickState = 0;
        this.breaking = true;
    }

    public void setPlacing() {
        this.leftClickState = 0;
        this.rightClickState = 0;
        this.placeState = true;
    }

    public void addName(String name) {
        this.id = name;
    }

    public void addLoot(ILoot loot) {
        this.loots.add(loot);
    }

    public void addConditionalLoot(ILoot loot, List<IResourceCondition> con) {
        this.conditionalLoot.put(loot, con.toArray(new IResourceCondition[con.size()]));
    }

    public void addMessage(String id, String message) {
        this.messages.put(id, message);
    }

    public boolean isValid() {
        return this.effects > 0 || this.loots.size() > 0;
    }

    public static BlockResourceBuilder createBuilder(JsonObject builder) {
        String type = builder.get("type").getAsString();
        if (type.equalsIgnoreCase("ore")) {
            return new OreResourceBuilder(builder.get("name").getAsString());
        }
        if (type.equalsIgnoreCase("block")) {
            Block block = Block.func_149684_b((String)builder.get("name").getAsString());
            if (block != null && block != Blocks.field_150350_a) {
                if (builder.has("metas")) {
                    return new ResourceBlockBuilder(block, builder.getAsJsonArray("metas"));
                }
                return new ResourceBlockBuilder(block, builder.has("meta") ? builder.get("meta").getAsInt() : Short.MAX_VALUE);
            }
        } else if (type.equalsIgnoreCase("block_list")) {
            return new ResourceBlockListBuilder(builder.getAsJsonArray("blocks"));
        }
        return null;
    }

    public IBlockResource create() {
        return new BlockResource(this.id, this.createBlocks(), this.properties, this.createLoot(), this.conditionalLoot, this.messages, this.leftClickState, this.rightClickState, this.breaking, this.placeState, this.shouldShow);
    }

    private List<ILoot> createLoot() {
        ArrayList<ILoot> rng = new ArrayList<ILoot>();
        ArrayList<ILoot> weigth = new ArrayList<ILoot>();
        for (ILoot loot : this.loots) {
            (loot.usesWeight() ? weigth : rng).add(loot);
        }
        if (weigth.size() > 0) {
            rng.add(new WeightLoot(weigth));
        }
        return rng;
    }

    protected abstract List<BlockEntry> createBlocks();

    public static class ResourceBlockListBuilder
    extends BlockResourceBuilder {
        List<BlockEntry> list = new ArrayList<BlockEntry>();

        public ResourceBlockListBuilder(JsonArray array) {
            for (JsonElement el : array) {
                if (!el.isJsonObject()) continue;
                this.add(el.getAsJsonObject());
            }
        }

        private void add(JsonObject obj) {
            Block block = Block.func_149684_b((String)obj.get("name").getAsString());
            if (block == null || block == Blocks.field_150350_a) {
                return;
            }
            if (obj.has("metas")) {
                for (JsonElement el : obj.getAsJsonArray("metas")) {
                    this.list.add(new BlockEntry(block, el.getAsInt()));
                }
            } else {
                this.list.add(new BlockEntry(block, obj.has("meta") ? obj.get("meta").getAsInt() : Short.MAX_VALUE));
            }
        }

        @Override
        protected List<BlockEntry> createBlocks() {
            return this.list;
        }
    }

    public static class OreResourceBuilder
    extends BlockResourceBuilder {
        String s;

        public OreResourceBuilder(String s) {
            this.s = s;
        }

        @Override
        protected List<BlockEntry> createBlocks() {
            ArrayList<BlockEntry> list = new ArrayList<BlockEntry>();
            for (ItemStack stack : OreDictionary.getOres((String)this.s)) {
                Block block = Block.func_149634_a((Item)stack.func_77973_b());
                if (block == null) continue;
                int meta = stack.func_77960_j();
                if (meta == Short.MAX_VALUE) {
                    list.add(new BlockEntry(block, meta));
                    continue;
                }
                list.add(new BlockEntry(block, stack.func_77973_b().func_77647_b(meta)));
            }
            return list;
        }
    }

    public static class ResourceBlockBuilder
    extends BlockResourceBuilder {
        Block block;
        int[] metas;

        public ResourceBlockBuilder(Block block, JsonArray jsonMeta) {
            this.block = block;
            this.metas = new int[jsonMeta.size()];
            for (int i = 0; i < this.metas.length; ++i) {
                this.metas[i] = jsonMeta.get(i).getAsInt();
            }
        }

        public ResourceBlockBuilder(Block block, int meta) {
            this.block = block;
            this.metas = new int[]{meta};
        }

        @Override
        protected List<BlockEntry> createBlocks() {
            ArrayList<BlockEntry> list = new ArrayList<BlockEntry>();
            for (int meta : this.metas) {
                list.add(new BlockEntry(this.block, meta));
            }
            return list;
        }
    }
}

