/*
 * Decompiled with CFR 0.152.
 */
package scavenge.core.builder.loot;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import scavenge.api.loot.ILootProperty;
import scavenge.api.utils.LootUtil;
import scavenge.core.loot.BasicLoot;
import scavenge.core.loot.ILoot;

public class LootBuilder {
    List<ILootProperty> properties = new ArrayList<ILootProperty>();
    ItemStack stack;
    boolean weight;
    float value;
    int maxRolls;
    boolean shouldShow = true;

    public LootBuilder(ItemStack stack) {
        this.stack = stack;
    }

    public void setProperties(JsonObject obj) {
        if (obj.has("chance")) {
            this.weight = false;
            this.value = obj.get("chance").getAsFloat();
            this.maxRolls = obj.has("rolls") ? obj.get("rolls").getAsInt() : Integer.MAX_VALUE;
        } else if (obj.has("weight")) {
            this.weight = true;
            this.value = obj.get("weight").getAsInt();
        } else {
            this.weight = false;
            this.value = 100.0f;
            this.maxRolls = Integer.MAX_VALUE;
        }
        if (obj.has("disableJEI")) {
            this.shouldShow = !obj.get("disableJEI").getAsBoolean();
        }
    }

    public boolean addProperty(ILootProperty prop) {
        for (ILootProperty loot : this.properties) {
            if (loot.canCombine(prop) && prop.canCombine(loot)) continue;
            return false;
        }
        this.properties.add(prop);
        return true;
    }

    public ILoot build() {
        ArrayList<ILootProperty> lootProps = new ArrayList<ILootProperty>();
        for (ILootProperty prop : this.properties) {
            if (prop.isActiveProperty()) {
                lootProps.add(prop);
                continue;
            }
            this.stack = prop.applyPassiveEffect(this.stack);
            if (!LootUtil.isStackEmpty(this.stack)) continue;
            return null;
        }
        return new BasicLoot(this.stack, this.weight, this.value, this.maxRolls, this.properties, this.shouldShow);
    }
}

