/*
 * Decompiled with CFR 0.152.
 */
package scavenge.core.math.modifiers;

import com.google.gson.JsonObject;
import scavenge.api.autodoc.LongElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.math.IMathModifier;
import scavenge.api.math.impl.BaseMathModifier;
import scavenge.api.math.impl.BaseModifierFactory;

public class ModulusModifier
extends BaseMathModifier {
    long value;

    public ModulusModifier(JsonObject obj) {
        this(obj.get("value").getAsLong());
    }

    public ModulusModifier(long value) {
        super("Modulo");
        this.value = value;
    }

    @Override
    public long modify(long input) {
        return input % this.value;
    }

    public static class ModulusFactory
    extends BaseModifierFactory {
        public ModulusFactory() {
            super("Modulo");
        }

        @Override
        public IMathModifier createObject(JsonObject obj) {
            return new ModulusModifier(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = new MapElement("");
            map.addElement(new LongElement("value", 0L).setDescription("The Value that should be Modulo with"));
            map.setDescription("Applies the Selected Modulo to the Input Value");
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("value", (Number)20);
        }
    }
}

