/*
 * Decompiled with CFR 0.152.
 */
package scavenge.core.math.operation;

import com.google.gson.JsonObject;
import scavenge.api.autodoc.LongElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.math.IMathOperation;
import scavenge.api.math.impl.BaseMathOperation;
import scavenge.api.math.impl.BaseOperationFactory;
import scavenge.api.utils.CompatState;

public class BiggerOperation
extends BaseMathOperation {
    long check;

    public BiggerOperation(JsonObject obj) {
        this(obj.get("value").getAsLong());
        if (obj.has("modifiers")) {
            this.addMathModifiers(obj.get("modifiers"));
        }
    }

    public BiggerOperation(long value) {
        super("bigger");
        this.check = value;
    }

    @Override
    public boolean matches(long value) {
        return this.getValue(value) > this.check;
    }

    public static class BiggerFactory
    extends BaseOperationFactory {
        public BiggerFactory() {
            super("bigger");
            this.setCompatState(CompatState.PARTCOMPATIBLE);
        }

        @Override
        public IMathOperation createObject(JsonObject obj) {
            return new BiggerOperation(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new LongElement("value", 0L).setDescription("The Value the Operation should compare with"));
            map.setDescription("Checks if the Input Value is bigger then the selected Value");
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("value", (Number)100);
        }
    }
}

