/*
 * Decompiled with CFR 0.152.
 */
package scavenge.loot.effects;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import scavenge.api.autodoc.ArrayElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.loot.ILootProperty;
import scavenge.api.loot.impl.BaseActiveLootProperty;
import scavenge.api.loot.impl.BaseLootFactory;
import scavenge.api.utils.JsonUtil;

public class PropAddRandomDamage
extends BaseActiveLootProperty {
    List<Integer> damage = new ArrayList<Integer>();

    public PropAddRandomDamage(JsonObject obj) {
        super("set_random_damage");
        JsonUtil.convertToPrimitive(obj.get("damages"), new Consumer<JsonPrimitive>(){

            @Override
            public void accept(JsonPrimitive t) {
                PropAddRandomDamage.this.damage.add(t.getAsInt());
            }
        });
    }

    @Override
    public ItemStack applyActiveEffect(ItemStack stack, NBTTagCompound customData) {
        stack.func_77964_b(this.damage.get(rand.nextInt(this.damage.size())).intValue());
        return stack;
    }

    @Override
    public List<ItemStack> applyMultiInfoEffect(ItemStack stack) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (Integer data : this.damage) {
            ItemStack copy = stack.func_77946_l();
            copy.func_77964_b(data.intValue());
            list.add(copy);
        }
        return list;
    }

    public static class AddRandomDamageFactory
    extends BaseLootFactory {
        public AddRandomDamageFactory() {
            super("set_random_damage", true);
        }

        @Override
        public ILootProperty createObject(JsonObject obj) {
            return new PropAddRandomDamage(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = new MapElement("");
            map.setDescription("Allows to set random damage on items");
            map.addElement(new ArrayElement("damages", new IntElement("", 0)).setDescription("The damages for the item"));
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            JsonArray array = new JsonArray();
            obj.add("damages", (JsonElement)array);
            array.add((JsonElement)new JsonPrimitive((Number)24));
            array.add((JsonElement)new JsonPrimitive((Number)2));
            array.add((JsonElement)new JsonPrimitive((Number)4));
            array.add((JsonElement)new JsonPrimitive((Number)244));
        }
    }
}

