/*
 * Decompiled with CFR 0.152.
 */
package scavenge.loot.mixed;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.loot.ILootProperty;
import scavenge.api.loot.impl.BaseActiveLootProperty;
import scavenge.api.loot.impl.BaseLootFactory;
import scavenge.api.utils.JsonUtil;
import scavenge.loot.mixed.PropHasFlag;

public class PropHasNumber
extends BaseActiveLootProperty {
    String tagID;
    int value;
    ILootProperty prop;

    public PropHasNumber(JsonObject obj) {
        super("set_has_Number");
        this.tagID = obj.get("NumberID").getAsString();
        this.value = JsonUtil.getOrDefault(obj, "value", 0);
        this.prop = this.createLoot(obj.getAsJsonObject("loot"));
    }

    @Override
    public ItemStack applyActiveEffect(ItemStack stack, NBTTagCompound customData) {
        if (customData.func_74764_b(this.tagID) && customData.func_74762_e(this.tagID) == this.value) {
            if (this.prop.isActiveProperty()) {
                return this.prop.applyActiveEffect(stack, customData);
            }
            this.prop.applyPassiveEffect(stack);
        }
        return stack;
    }

    @Override
    public List<ItemStack> applyMultiInfoEffect(ItemStack stack) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(stack.func_77946_l());
        if (this.prop.hasMultiResults()) {
            list.addAll(this.prop.applyMultiInfoEffect(stack));
        } else {
            list.add(this.prop.applyInfoEffect(stack));
        }
        return list;
    }

    public static class HasNumberFactory
    extends BaseLootFactory {
        public HasNumberFactory() {
            super("set_has_Number", true);
        }

        @Override
        public ILootProperty createObject(JsonObject obj) {
            return new PropHasFlag(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = new MapElement("");
            map.addElement(new TextElement("NumberID", "").setDescription("The ID of the the Number that should be checkt for"));
            map.addElement(new IntElement("value", 0, "What the number should be"));
            map.addElement(new MapElement("loot").setDescription("The LootProperty that should be applied"));
            map.setDescription("Allows to add a LootProperty based on Data thats being send from the Block Property (sendNumberToLoot)");
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            JsonObject data = new JsonObject();
            data.addProperty("type", "lootID");
            obj.add("loot", (JsonElement)data);
            obj.addProperty("NumberID", "CustomNumberID");
            obj.addProperty("value", (Number)12453);
        }
    }
}

