/*
 * Decompiled with CFR 0.152.
 */
package scavenge.player.blockConditions;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import scavenge.api.autodoc.ArrayElement;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;
import scavenge.api.utils.LootUtil;

public class PropHasItem
extends BaseResourceProperty
implements IResourceCondition {
    ItemStack compareStack;
    int damageLimit;
    List<String> tags = new ArrayList<String>();
    boolean offhand;

    public PropHasItem(JsonObject obj) {
        super(obj, "require_item");
        this.addIncompats("require_item_list", "require_tool", "require_empty_Hand");
        this.compareStack = JsonUtil.createCompareStack(obj);
        if (this.compareStack == null) {
            throw new RuntimeException("Item [" + obj.get("name") + "] is null. That is not allowed");
        }
        this.offhand = JsonUtil.getOrDefault(obj, "offhand", false);
        this.damageLimit = JsonUtil.getOrDefault(obj, "required_durability", -1);
        JsonUtil.convertToPrimitive(obj.get("tags"), new Consumer<JsonPrimitive>(){

            @Override
            public void accept(JsonPrimitive t) {
                PropHasItem.this.tags.add(t.getAsString());
            }
        });
    }

    @Override
    public void addJEIData(IResourceProperty.IJEIBlockHandler collector) {
        ItemStack copy = this.compareStack.func_77946_l();
        NBTTagList list = copy.func_190925_c("display").func_150295_c("Lore", 8);
        copy.func_190925_c("display").func_74782_a("Lore", (NBTBase)list);
        if (this.damageLimit != -1) {
            list.func_74742_a((NBTBase)new NBTTagString(TextFormatting.RESET + " Required Durability: " + this.damageLimit));
        }
        list.func_74742_a((NBTBase)new NBTTagString(TextFormatting.RESET + " Required Tags: " + this.tags));
        if (this.offhand) {
            list.func_74742_a((NBTBase)new NBTTagString(TextFormatting.RESET + " Item is required on the Offhand"));
        }
        collector.addRequiredItem(copy);
        collector.addInfo("Requires Item: [" + copy.func_82833_r() + "]");
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        ItemStack stack = player.func_184586_b(this.offhand ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND);
        if (LootUtil.isStackEmpty(stack)) {
            return false;
        }
        if (stack.func_77973_b() != this.compareStack.func_77973_b()) {
            return false;
        }
        if (this.compareStack.func_77960_j() != Short.MAX_VALUE && this.compareStack.func_77960_j() != stack.func_77960_j()) {
            return false;
        }
        if (LootUtil.getStackSize(stack) < LootUtil.getStackSize(this.compareStack)) {
            return false;
        }
        if (this.damageLimit > -1 && stack.func_77958_k() > 0 && stack.func_77958_k() - stack.func_77952_i() < this.damageLimit) {
            return false;
        }
        return this.tags.size() <= 0 || stack.func_77942_o() && stack.func_77978_p().func_150296_c().containsAll(this.tags);
    }

    public static class HasItemFactory
    extends BaseResourceFactory {
        public HasItemFactory() {
            super("require_item", IResourceFactory.PropertyType.Condition);
            this.setCompatState(CompatState.PARTCOMPATIBLE);
            this.addIncompats(CompatState.INCOMPATIBLE, "require_item_list", "require_tool", "require_empty_Hand");
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropHasItem(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.setDescription("Allows to check if the Player has a Item in his main or offHand");
            map.addElement(new TextElement("name", "").setDescription("Item that should be compared with"));
            map.addElement(new IntElement("meta", Short.MAX_VALUE, "The Metadata that should be compared with. 32767 = IgnoreMeta"));
            map.addElement(new IntElement("amount", 1, "The Stacksize that is required"));
            map.addElement(new BooleanElement("offhand", false, "If the Item should be at the Offhand or not"));
            map.addElement(new IntElement("required_durability", -1, "The Durability that is required"));
            map.addElement(new ArrayElement("tags", new TextElement("", "")).setDescription("Required NBTTags that the item should have"));
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("name", "minecraft:stone_pickaxe");
            obj.addProperty("meta", (Number)Short.MAX_VALUE);
            obj.addProperty("amount", (Number)1);
            obj.addProperty("required_durability", (Number)100);
            JsonArray array = new JsonArray();
            array.add((JsonElement)new JsonPrimitive("ench"));
            obj.add("tags", (JsonElement)array);
        }
    }
}

