/*
 * Decompiled with CFR 0.152.
 */
package scavenge.player.blockConditions;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.ScavengeAPI;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;
import scavenge.api.utils.LootUtil;

public class PropHasNBTTag
extends BaseResourceProperty
implements IResourceCondition {
    NBTTagCompound nbt;
    boolean offHand;
    boolean require;

    public PropHasNBTTag(JsonObject obj) {
        super(obj, "item_has_nbt");
        this.nbt = ScavengeAPI.INSTANCE.getCompound(obj.get("name").getAsString());
        this.offHand = JsonUtil.getOrDefault(obj, "offHand", false);
        this.require = JsonUtil.getOrDefault(obj, "require", true);
        this.setJEIInfo("Player Item Requires a NBTCompound");
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        ItemStack stack = player.func_184586_b(this.offHand ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND);
        if (LootUtil.isStackEmpty(stack)) {
            return false;
        }
        if (this.require) {
            return NBTUtil.func_181123_a((NBTBase)this.nbt, (NBTBase)stack.func_77978_p(), (boolean)true);
        }
        return !NBTUtil.func_181123_a((NBTBase)this.nbt, (NBTBase)stack.func_77978_p(), (boolean)true);
    }

    public static class HasNBTTagFactory
    extends BaseResourceFactory {
        public HasNBTTagFactory() {
            super("item_has_nbt", IResourceFactory.PropertyType.Condition);
            this.setCompatState(CompatState.PARTCOMPATIBLE);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropHasNBTTag(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("name", "customNBTID");
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.setDescription("Allows you to check if a Item has a NBTTagCompound");
            map.addElement(new BooleanElement("require", true, "If the NBTTagCompound is required or not"));
            map.addElement(new BooleanElement("offHand", false, "If the Item to use should be from the Main or Offhand"));
            map.addElement(new TextElement("name", "").setDescription("The id of the NBTFile Reference for the NBTTagCompound to use"));
            return map;
        }
    }
}

