/*
 * Decompiled with CFR 0.152.
 */
package scavenge.player.blockConditions;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;

public class PropIsPlayerWet
extends BaseResourceProperty
implements IResourceCondition {
    boolean required;

    public PropIsPlayerWet(JsonObject obj) {
        super(obj, "require_wet");
        this.addSelfIncompat();
        this.required = JsonUtil.getOrDefault(obj, "required", true);
        if (this.required) {
            this.setJEIInfo("Player has to be wet");
        } else {
            this.setJEIInfo("Player is not allowed to be wet");
        }
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        return player.func_70026_G() == this.required;
    }

    public static class IsPlayerWetFactory
    extends BaseResourceFactory {
        public IsPlayerWetFactory() {
            super("require_wet", IResourceFactory.PropertyType.Condition);
            this.setCompatState(CompatState.INCOMPATIBLE);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropIsPlayerWet(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("required", Boolean.valueOf(true));
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.setDescription("Allows if the Player is wet (in rain or water)");
            map.addElement(new BooleanElement("required", true, "If the Player should be wet or not"));
            return map;
        }
    }
}

