/*
 * Decompiled with CFR 0.152.
 */
package scavenge.player.blockEffects;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.FoodStats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.FloatElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.JsonUtil;

public class PropAddHunger
extends BaseResourceProperty
implements IResourceEffect {
    boolean exhaustion;
    float amount;

    public PropAddHunger(JsonObject obj) {
        super(obj, "add_hunger");
        this.exhaustion = JsonUtil.getOrDefault(obj, "exhaustion", true);
        this.amount = obj.get("amount").getAsFloat();
        if (this.exhaustion) {
            this.setJEIInfo("Adds " + this.amount + " Exhaustion to the Player");
        } else {
            this.setJEIInfo("Adds " + this.amount + " Hunger to the Player");
        }
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        if (this.exhaustion) {
            player.func_71020_j(this.amount);
            return true;
        }
        FoodStats food = player.func_71024_bL();
        food.func_75114_a(Math.max(0, Math.min(20, food.func_75116_a() - (int)this.amount)));
        return true;
    }

    public static class AddHungerFactory
    extends BaseResourceFactory {
        public AddHungerFactory() {
            super("add_hunger", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropAddHunger(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("exhaustion", Boolean.valueOf(true));
            obj.addProperty("amount", (Number)Float.valueOf(1.0f));
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.setDescription("Allows to add Hunger/Exhaustion to the Player");
            map.addElement(new BooleanElement("exhaustion", true, "If the Effect should add Exhaustion or remove Hunger directly"));
            map.addElement(new FloatElement("amount", 1.0f).setDescription("How much Exaustion should be added or how much hunger should be removed"));
            return map;
        }
    }
}

