/*
 * Decompiled with CFR 0.152.
 */
package scavenge.player.blockEffects;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.OptionalArrayElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.JsonUtil;
import scavenge.api.utils.LootUtil;
import scavenge.api.utils.StackObject;

public class PropPlayerConumeItems
extends BaseResourceProperty
implements IResourceEffect {
    List<StackObject> list = new ArrayList<StackObject>();

    public PropPlayerConumeItems(JsonObject obj) {
        super(obj, "consume_player_items");
        JsonUtil.convertToObject(obj.get("items"), new Consumer<JsonObject>(){

            @Override
            public void accept(JsonObject t) {
                StackObject obj = JsonUtil.createStackObject(t);
                if (obj == null) {
                    throw new RuntimeException("Object [" + t + "] caused a null Object this is not allowed");
                }
                PropPlayerConumeItems.this.list.add(obj);
            }
        });
    }

    @Override
    public void addJEIData(IResourceProperty.IJEIBlockHandler collector) {
        collector.addExtraLayer("Player Items get Consumed");
        for (StackObject obj : this.list) {
            collector.addInfo(obj.getStackize() + "x " + obj.getName());
        }
        collector.finishLayer();
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        ArrayList<StackObject> toConsume = new ArrayList<StackObject>(this.list.size());
        for (StackObject entry : this.list) {
            this.list.add(entry);
        }
        InventoryPlayer inv = player.field_71071_by;
        this.consumeInventory((NonNullList<ItemStack>)inv.field_70462_a, toConsume);
        this.consumeInventory((NonNullList<ItemStack>)inv.field_70460_b, toConsume);
        this.consumeInventory((NonNullList<ItemStack>)inv.field_184439_c, toConsume);
        return true;
    }

    private void consumeInventory(NonNullList<ItemStack> array, List<StackObject> stackList) {
        if (stackList.isEmpty()) {
            return;
        }
        for (int i = 0; i < array.size(); ++i) {
            ItemStack stack = (ItemStack)array.get(i);
            if (LootUtil.isStackEmpty(stack)) continue;
            int stackSize = LootUtil.getStackSize(stack);
            Iterator<StackObject> iter = stackList.iterator();
            while (iter.hasNext()) {
                StackObject obj = iter.next();
                if (!obj.matches(stack)) continue;
                if (obj.getStackize() <= stackSize) {
                    stackSize -= obj.getStackize();
                    iter.remove();
                } else {
                    obj.decreaseStackSize(stackSize);
                    stackSize = 0;
                }
                if (stackSize > 0) continue;
                break;
            }
            if (stackSize == 0) {
                array.set(i, (Object)LootUtil.getNullStack());
            } else {
                LootUtil.setStackSize(stack, stackSize);
            }
            if (!stackList.isEmpty()) continue;
            return;
        }
    }

    public static class PlayerConsumeItemsFactory
    extends BaseResourceFactory {
        public PlayerConsumeItemsFactory() {
            super("consume_player_items", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropPlayerConumeItems(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            JsonObject object = new JsonObject();
            object.addProperty("name", "minecraft:stick");
            object.addProperty("amount", (Number)32);
            JsonArray array = new JsonArray();
            array.add((JsonElement)object);
            obj.add("items", (JsonElement)array);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement base = new MapElement("");
            base.addElement(new TextElement("name", "").setDescription("The Item that should be consumed"));
            base.addElement(new IntElement("meta", Short.MAX_VALUE, "The Metadata of the item that should be consumed 32767 = any meta"));
            base.addElement(new IntElement("amount", 1, "How many items should be consumed"));
            base.addElement(new TextElement("nbt", "null", "The NBTData the item should have that should be consumed"));
            MapElement map = super.getDocumentation();
            map.addElement(new OptionalArrayElement("items", base));
            map.setDescription("Allows to consume items from a Players inventory");
            return map;
        }
    }
}

