/*
 * Decompiled with CFR 0.152.
 */
package scavenge.tileentity.blockConditions;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.math.IMathOperation;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;
import scavenge.api.utils.LootUtil;
import scavenge.core.math.operation.BiggerOperation;
import scavenge.core.math.operation.SmallerOperation;

public class PropItemHasFE
extends BaseResourceProperty
implements IResourceCondition {
    IMathOperation operation;

    public PropItemHasFE(JsonObject obj) {
        super(obj, "item_has_FE");
        if (obj.has("operations")) {
            this.operation = JsonUtil.getMathOperation("operations", obj);
            this.setJEIInfo(JsonUtil.getOrDefault(obj, "jeiDesc", ""));
        } else {
            int value = JsonUtil.getOrDefault(obj, "amount", 0);
            if (JsonUtil.getOrDefault(obj, "bigger", true)) {
                this.operation = new BiggerOperation(value);
                this.setJEIInfo("HeldItem has to have more then " + value + " Forge Energy");
            } else {
                this.operation = new SmallerOperation(value);
                this.setJEIInfo("HeldItem has to have less then " + value + " Forge Energy");
            }
        }
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        ItemStack stack = player.func_184614_ca();
        if (LootUtil.isStackEmpty(stack) || !stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            return false;
        }
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        return this.operation.matches(storage.getEnergyStored());
    }

    public static class ItemHasFEFactory
    extends BaseResourceFactory {
        public ItemHasFEFactory() {
            super("item_has_FE", IResourceFactory.PropertyType.Condition);
            this.setCompatState(CompatState.PARTCOMPATIBLE);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropItemHasFE(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("bigger", Boolean.valueOf(true));
            obj.addProperty("amount", (Number)50000);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.setDescription("Allows to check for Forge Energy inside of a Block");
            map.addElement(new BooleanElement("bigger", true, "If the Block should have more or less ForgeEnergy then requested"));
            map.addElement(new IntElement("amount", 0, "How much forge Energy Should be checkt for"));
            return map;
        }
    }
}

