/*
 * Decompiled with CFR 0.152.
 */
package scavenge.utils.blockConditions;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.ArrayElement;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.JsonUtil;

public class PropArrayCondition
extends BaseResourceProperty
implements IResourceCondition {
    boolean and;
    List<IResourceCondition> list = new ArrayList<IResourceCondition>();

    public PropArrayCondition(JsonObject obj) {
        super(obj, "array_condition");
        this.and = JsonUtil.getOrDefault(obj, "and", true);
        JsonUtil.convertToObject(obj.get("conditions"), new Consumer<JsonObject>(){

            @Override
            public void accept(JsonObject t) {
                PropArrayCondition.this.list.add(PropArrayCondition.this.createCondition(t));
            }
        });
    }

    @Override
    public void addJEIData(IResourceProperty.IJEIBlockHandler collector) {
        collector.addExtraLayer("Array Condition");
        collector.addInfo(this.and ? "All Conditions are required" : "Any of these condtion have to match");
        for (IResourceCondition entry : this.list) {
            entry.addJEIData(collector);
        }
        collector.finishLayer();
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        if (this.and) {
            for (IResourceCondition condition : this.list) {
                if (condition.canInteract(state, world, pos, player, leftClick, side, resourceID, client)) continue;
                return false;
            }
            return true;
        }
        for (IResourceCondition condition : this.list) {
            if (!condition.canInteract(state, world, pos, player, leftClick, side, resourceID, client)) continue;
            return true;
        }
        return false;
    }

    public static class ArrayConditionFactory
    extends BaseResourceFactory {
        public ArrayConditionFactory() {
            super("array_condition", IResourceFactory.PropertyType.Condition);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropArrayCondition(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            JsonObject base = new JsonObject();
            base.addProperty("type", "exampleCondition");
            JsonArray array = new JsonArray();
            array.add((JsonElement)base);
            obj.add("conditions", (JsonElement)array);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.setDescription("Allows to combine conditions together");
            map.addElement(new ArrayElement("", map).setDescription("The Conditions that should be added"));
            map.addElement(new BooleanElement("and", true, "If all conditions are required or just 1 of them"));
            return map;
        }
    }
}

