/*
 * Decompiled with CFR 0.152.
 */
package scavenge.world.blockConditions;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.ChoiceElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.math.IMathOperation;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;
import scavenge.core.math.operation.InRangeOperation;
import scavenge.core.math.operation.NotInRangeOperation;

public class PropWorldTime
extends BaseResourceProperty
implements IResourceCondition {
    IMathOperation operation;

    public PropWorldTime(JsonObject obj) {
        super(obj, "require_time");
        if (obj.has("operation")) {
            this.operation = JsonUtil.getMathOperation("operations", obj);
            this.setJEIInfo(JsonUtil.getOrDefault(obj, "jeiDesc", ""));
        } else {
            int min = obj.get("minValue").getAsInt();
            int max = obj.get("maxValue").getAsInt();
            if (JsonUtil.getOrDefault(obj, "InRange", true)) {
                this.operation = new InRangeOperation(min, max);
                this.setJEIInfo("Time has to be between " + min + " and " + max);
            } else {
                this.operation = new NotInRangeOperation(min, max);
                this.setJEIInfo("Time has to be outside " + min + " and " + max);
            }
        }
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        return this.operation.matches(world.func_72820_D());
    }

    public static class WorldTimeFactory
    extends BaseResourceFactory {
        public WorldTimeFactory() {
            super("require_time", IResourceFactory.PropertyType.Condition);
            this.setCompatState(CompatState.PARTCOMPATIBLE);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropWorldTime(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement el = super.getDocumentation();
            ChoiceElement choice = new ChoiceElement("", 2);
            choice.addElement(0, new IntElement("minValue", 0).setDescription("Minimum Time that should be checkt for"));
            choice.addElement(0, new IntElement("maxValue", 0).setDescription("Maximum Time that should be checkt for"));
            choice.addElement(0, new BooleanElement("inRange", true, "If the Check range should be inclusive or exclusive"));
            this.addDefaultOperationText(choice, 1);
            el.addElement(choice);
            el.setDescription("Allows to check if the World has a Certain Time of the Day");
            return el;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("inRange", Boolean.valueOf(true));
            obj.addProperty("minValue", (Number)12000);
            obj.addProperty("maxValue", (Number)18000);
        }
    }
}

