/*
 * Decompiled with CFR 0.152.
 */
package lykrast.mysticalwildlife.common.entity;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import lykrast.mysticalwildlife.common.init.ModItems;
import lykrast.mysticalwildlife.common.init.ModSounds;
import lykrast.mysticalwildlife.common.util.ModConfig;
import lykrast.mysticalwildlife.common.util.ResourceUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public abstract class EntityCicaptera
extends EntityAnimal {
    private static final Set<Item> SEEDS = Sets.newHashSet((Object[])new Item[]{Items.field_151014_N, Items.field_185163_cU, Items.field_151081_bc, Items.field_151080_bb});
    private static final Set<Item> FRUITS = Sets.newHashSet((Object[])new Item[]{Items.field_151034_e});
    private static final Set<Item> CACTUS = Sets.newHashSet((Object[])new Item[]{Item.func_150898_a((Block)Blocks.field_150434_aF)});
    private static final Set<Item> SUGAR = Sets.newHashSet((Object[])new Item[]{Items.field_151102_aT});

    public EntityCicaptera(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 0.4f);
    }

    protected abstract Set<Item> getTemptationItems();

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.25));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0, EntityCicaptera.class));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.2, false, this.getTemptationItems()));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.27);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        if (ageable instanceof EntityCicaptera && this.field_70146_Z.nextBoolean()) {
            return ((EntityCicaptera)ageable).createOwnChild();
        }
        return this.createOwnChild();
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal == this || !(otherAnimal instanceof EntityCicaptera)) {
            return false;
        }
        return this.func_70880_s() && otherAnimal.func_70880_s();
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    protected abstract EntityAgeable createOwnChild();

    protected SoundEvent func_184639_G() {
        return ModSounds.cicapteraIdle;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return ModSounds.cicapteraHurt;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.cicapteraDeath;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.15f, 1.0f);
    }

    public boolean func_70877_b(ItemStack stack) {
        return this.getTemptationItems().contains(stack.func_77973_b());
    }

    public static class Lovely
    extends EntityCicaptera {
        public static final ResourceLocation LOOT = ResourceUtil.getEntityLootTable("cicaptera/lovely");
        public int timeUntilNextEssence;

        public Lovely(World worldIn) {
            super(worldIn);
            this.resetEssenceTime();
        }

        @Override
        public void func_70636_d() {
            super.func_70636_d();
            if (!this.field_70170_p.field_72995_K && !this.func_70631_g_() && --this.timeUntilNextEssence <= 0) {
                this.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                this.func_145779_a(ModItems.aphroditeEssence, 1);
                this.resetEssenceTime();
            }
        }

        private void resetEssenceTime() {
            this.timeUntilNextEssence = this.field_70146_Z.nextInt(ModConfig.cicapteraLovelyEssenceTimeBase) + ModConfig.cicapteraLovelyEssenceTimeExtra;
        }

        public void func_70037_a(NBTTagCompound compound) {
            super.func_70037_a(compound);
            if (compound.func_74764_b("EssenceTime")) {
                this.timeUntilNextEssence = compound.func_74762_e("EssenceTime");
            }
        }

        public void func_70014_b(NBTTagCompound compound) {
            super.func_70014_b(compound);
            compound.func_74768_a("EssenceTime", this.timeUntilNextEssence);
        }

        @Override
        protected Set<Item> getTemptationItems() {
            return SUGAR;
        }

        @Nullable
        protected ResourceLocation func_184647_J() {
            return LOOT;
        }

        @Override
        protected EntityAgeable createOwnChild() {
            return new Lovely(this.field_70170_p);
        }
    }

    public static class Wintry
    extends EntityCicaptera {
        public static final ResourceLocation LOOT = ResourceUtil.getEntityLootTable("cicaptera/wintry");

        public Wintry(World worldIn) {
            super(worldIn);
        }

        @Override
        protected Set<Item> getTemptationItems() {
            return SEEDS;
        }

        @Nullable
        protected ResourceLocation func_184647_J() {
            return LOOT;
        }

        @Override
        protected EntityAgeable createOwnChild() {
            return new Wintry(this.field_70170_p);
        }
    }

    public static class Sandy
    extends EntityCicaptera {
        public static final ResourceLocation LOOT = ResourceUtil.getEntityLootTable("cicaptera/sandy");

        public Sandy(World worldIn) {
            super(worldIn);
        }

        @Override
        protected Set<Item> getTemptationItems() {
            return CACTUS;
        }

        @Nullable
        protected ResourceLocation func_184647_J() {
            return LOOT;
        }

        @Override
        protected EntityAgeable createOwnChild() {
            return new Sandy(this.field_70170_p);
        }
    }

    public static class Crimson
    extends EntityCicaptera {
        public static final ResourceLocation LOOT = ResourceUtil.getEntityLootTable("cicaptera/crimson");

        public Crimson(World worldIn) {
            super(worldIn);
        }

        @Override
        protected Set<Item> getTemptationItems() {
            return CACTUS;
        }

        @Override
        protected void func_184651_r() {
            this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AICrimsonLeap(this));
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.2, false));
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.2, false, SEEDS));
            this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
            this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
            this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
            this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        }

        public boolean func_70652_k(Entity entityIn) {
            boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 3.0f);
            if (flag) {
                entityIn.field_70159_w += this.field_70159_w;
                entityIn.field_70181_x += this.field_70181_x;
                entityIn.field_70179_y += this.field_70179_y;
            }
            this.field_70159_w *= -1.0;
            this.field_70181_x *= -1.0;
            this.field_70179_y *= -1.0;
            return flag;
        }

        protected void func_70619_bc() {
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
                if (this.func_70638_az() != null) {
                    this.func_70624_b(null);
                }
                if (this.func_70643_av() != null) {
                    this.func_70604_c(null);
                }
            }
            super.func_70619_bc();
        }

        @Nullable
        protected ResourceLocation func_184647_J() {
            return LOOT;
        }

        @Override
        protected EntityAgeable createOwnChild() {
            return new Crimson(this.field_70170_p);
        }

        private static class AICrimsonLeap
        extends EntityAILeapAtTarget {
            private EntityLiving leaper;
            private boolean attacked;

            public AICrimsonLeap(EntityCicaptera leapingEntity) {
                super((EntityLiving)leapingEntity, 0.5f);
                this.leaper = leapingEntity;
            }

            public void func_75249_e() {
                this.attacked = false;
                EntityLivingBase leapTarget = this.leaper.func_70638_az();
                if (leapTarget == null) {
                    return;
                }
                double d0 = leapTarget.field_70165_t - this.leaper.field_70165_t;
                double d1 = leapTarget.field_70161_v - this.leaper.field_70161_v;
                float f = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
                if ((double)f >= 1.0E-4) {
                    this.leaper.field_70159_w += d0 / (double)f * 0.8 + this.leaper.field_70159_w * 0.2;
                    this.leaper.field_70179_y += d1 / (double)f * 0.8 + this.leaper.field_70179_y * 0.2;
                }
                this.leaper.field_70181_x = 0.5;
            }

            public void func_75246_d() {
                double range;
                EntityLivingBase leapTarget = this.leaper.func_70638_az();
                if (leapTarget == null || this.attacked) {
                    return;
                }
                double distance = this.leaper.func_70092_e(leapTarget.field_70165_t, (leapTarget.func_174813_aQ().field_72338_b + leapTarget.func_174813_aQ().field_72337_e) / 2.0, leapTarget.field_70161_v);
                if (distance <= (range = (double)(this.leaper.field_70130_N * this.leaper.field_70130_N + leapTarget.field_70130_N))) {
                    this.attacked = true;
                    this.leaper.func_70652_k((Entity)leapTarget);
                }
            }
        }
    }

    public static class Verdant
    extends EntityCicaptera {
        public static final ResourceLocation LOOT = ResourceUtil.getEntityLootTable("cicaptera/verdant");

        public Verdant(World worldIn) {
            super(worldIn);
        }

        @Override
        protected Set<Item> getTemptationItems() {
            return FRUITS;
        }

        @Nullable
        protected ResourceLocation func_184647_J() {
            return LOOT;
        }

        @Override
        protected EntityAgeable createOwnChild() {
            return new Verdant(this.field_70170_p);
        }
    }

    public static class Azure
    extends EntityCicaptera {
        public static final ResourceLocation LOOT = ResourceUtil.getEntityLootTable("cicaptera/azure");

        public Azure(World worldIn) {
            super(worldIn);
        }

        @Override
        protected Set<Item> getTemptationItems() {
            return SEEDS;
        }

        @Nullable
        protected ResourceLocation func_184647_J() {
            return LOOT;
        }

        @Override
        protected EntityAgeable createOwnChild() {
            return new Azure(this.field_70170_p);
        }
    }
}

