/*
 * Decompiled with CFR 0.152.
 */
package lykrast.mysticalwildlife.common.entity;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import lykrast.mysticalwildlife.common.entity.EntityFurzard;
import lykrast.mysticalwildlife.common.init.ModPotions;
import lykrast.mysticalwildlife.common.init.ModSounds;
import lykrast.mysticalwildlife.common.util.LootUtil;
import lykrast.mysticalwildlife.common.util.ResourceUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTable;

public class EntityVrontausaurus
extends EntityFurzard {
    public static final ResourceLocation LOOT = ResourceUtil.getEntityLootTable("vrontausaurus");
    public static final ResourceLocation LOOT_BRUSH = ResourceUtil.getSpecialLootTable("brush_vrontausaurus");
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_151147_al, Items.field_151157_am, Items.field_151082_bd, Items.field_151083_be, Items.field_179561_bm, Items.field_179557_bn});

    public EntityVrontausaurus(World worldIn) {
        super(worldIn);
        this.func_70105_a(2.2f, 1.4f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIPanic(1.2));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIAttackMeleeShortrange((EntityCreature)this, 1.2, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AITempt((EntityCreature)this, 1.2, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.24);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 5.0f)) {
            if (entityIn instanceof EntityLivingBase) {
                int i = -1;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    i = 0;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    i = 1;
                }
                if (i >= 0) {
                    this.func_184185_a(ModSounds.spark, 1.0f, 1.0f);
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(ModPotions.shocked, 60, i));
                }
            }
            return true;
        }
        return false;
    }

    protected void func_70619_bc() {
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            if (this.func_70638_az() != null) {
                this.func_70624_b(null);
            }
            if (this.func_70643_av() != null) {
                this.func_70604_c(null);
            }
        }
        super.func_70619_bc();
    }

    @Override
    public boolean isBrushable(EntityPlayer player, ItemStack item, IBlockAccess world, BlockPos pos) {
        return !this.func_70631_g_() && this.isBrushable() && this.func_70638_az() == null;
    }

    @Override
    public List<ItemStack> onBrushed(EntityPlayer player, ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        if (this.field_70146_Z.nextInt(4) == 0) {
            player.func_70097_a(DamageSource.field_180137_b, 2.0f);
        }
        this.func_184185_a(ModSounds.brushing, 1.0f, 1.0f);
        this.func_184185_a(ModSounds.spark, 1.0f, 1.0f);
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.setBrushTimer(3600 + this.field_70146_Z.nextInt(2401));
        }
        LootTable loottable = this.field_70170_p.func_184146_ak().func_186521_a(LOOT_BRUSH);
        return loottable.func_186462_a(this.field_70146_Z, LootUtil.getBrushingContext((Entity)this, player, fortune));
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityVrontausaurus(this.field_70170_p);
    }

    protected SoundEvent func_184639_G() {
        return ModSounds.lizardIdle;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return ModSounds.lizardHurt;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.lizardDeath;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, 1.0f);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    public boolean func_70877_b(ItemStack stack) {
        if (!this.field_70170_p.func_72896_J()) {
            return false;
        }
        return TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }

    private static class AITempt
    extends EntityAITempt {
        private EntityCreature tempted;

        public AITempt(EntityCreature temptedEntityIn, double speedIn, boolean scaredByPlayerMovementIn, Set<Item> temptItemIn) {
            super(temptedEntityIn, speedIn, scaredByPlayerMovementIn, temptItemIn);
            this.tempted = temptedEntityIn;
        }

        public boolean func_75250_a() {
            if (!this.tempted.field_70170_p.func_72896_J()) {
                return false;
            }
            return super.func_75250_a();
        }
    }

    private static class AIAttackMeleeShortrange
    extends EntityAIAttackMelee {
        public AIAttackMeleeShortrange(EntityCreature creature, double speedIn, boolean useLongMemory) {
            super(creature, speedIn, useLongMemory);
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 9.0f + attackTarget.field_70130_N;
        }
    }

    class AIPanic
    extends EntityAIPanic {
        public AIPanic(double speed) {
            super((EntityCreature)EntityVrontausaurus.this, speed);
        }

        public boolean func_75250_a() {
            return !EntityVrontausaurus.this.func_70631_g_() && !EntityVrontausaurus.this.func_70027_ad() ? false : super.func_75250_a();
        }
    }
}

