/*
 * Decompiled with CFR 0.152.
 */
package lykrast.mysticalwildlife.common.entity;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import lykrast.mysticalwildlife.common.entity.IBrushable;
import lykrast.mysticalwildlife.common.util.LootUtil;
import lykrast.mysticalwildlife.common.util.ResourceUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTable;

public class EntityYagaHog
extends EntityAnimal
implements IBrushable {
    public static final ResourceLocation LOOT = ResourceUtil.getEntityLootTable("yaga_hog");
    public static final ResourceLocation LOOT_BRUSH = ResourceUtil.getSpecialLootTable("brush_yaga_hog");
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_151025_P});
    private static final DataParameter<Boolean> DIRTY = EntityDataManager.func_187226_a(EntityYagaHog.class, (DataSerializer)DataSerializers.field_187198_h);
    private int dirtTime;

    public EntityYagaHog(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 0.9f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DIRTY, (Object)Boolean.TRUE);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.25));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.2, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    public boolean isDirty() {
        return this.field_70170_p.field_72995_K ? (Boolean)this.field_70180_af.func_187225_a(DIRTY) : this.dirtTime <= 0;
    }

    public void setDirtTimer(int timer) {
        this.field_70180_af.func_187227_b(DIRTY, (Object)(timer <= 0 ? 1 : 0));
        this.dirtTime = timer;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && !this.isDirty()) {
            this.setDirtTimer(Math.max(0, this.dirtTime - (this.func_70026_G() ? 3 : 1)));
        }
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        Potion potion = potioneffectIn.func_188419_a();
        if (potion == MobEffects.field_76436_u) {
            return false;
        }
        return super.func_70687_e(potioneffectIn);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K && amount > 0.0f) {
            int amplifier = (int)Math.floor(amount / 10.0f * 3.0f);
            amplifier = MathHelper.func_76125_a((int)amplifier, (int)0, (int)3);
            this.spawnLingeringCloud(amplifier);
        }
        return super.func_70097_a(source, amount);
    }

    private void spawnLingeringCloud(int amplifier) {
        EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        entityareaeffectcloud.func_184483_a(2.5f);
        entityareaeffectcloud.func_184495_b(-0.5f);
        entityareaeffectcloud.func_184485_d(10);
        entityareaeffectcloud.func_184486_b(entityareaeffectcloud.func_184489_o() / 2);
        entityareaeffectcloud.func_184487_c(-entityareaeffectcloud.func_184490_j() / (float)entityareaeffectcloud.func_184489_o());
        entityareaeffectcloud.func_184496_a(new PotionEffect(MobEffects.field_76436_u, 200, amplifier));
        this.field_70170_p.func_72838_d((Entity)entityareaeffectcloud);
    }

    @Override
    public boolean isBrushable(EntityPlayer player, ItemStack item, IBlockAccess world, BlockPos pos) {
        return !this.func_70631_g_() && this.isDirty();
    }

    @Override
    public List<ItemStack> onBrushed(EntityPlayer player, ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        this.func_184185_a(SoundEvents.field_187882_fq, 1.0f, 1.0f);
        if (this.field_70146_Z.nextInt(3) == 0) {
            this.setDirtTimer(3600 + this.field_70146_Z.nextInt(2401));
        }
        LootTable loottable = this.field_70170_p.func_184146_ak().func_186521_a(LOOT_BRUSH);
        return loottable.func_186462_a(this.field_70146_Z, LootUtil.getBrushingContext((Entity)this, player, fortune));
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityYagaHog(this.field_70170_p);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187697_dL;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187703_dN;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187700_dM;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187709_dP, 0.15f, 1.0f);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("DirtTimer", this.dirtTime);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setDirtTimer(compound.func_74762_e("DirtTimer"));
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    public boolean func_70877_b(ItemStack stack) {
        return TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }
}

