/*
 * Decompiled with CFR 0.152.
 */
package lykrast.mysticalwildlife.common.init;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lykrast.mysticalwildlife.client.render.RenderCicaptera;
import lykrast.mysticalwildlife.client.render.RenderDuskLurker;
import lykrast.mysticalwildlife.client.render.RenderKrill;
import lykrast.mysticalwildlife.client.render.RenderPlumper;
import lykrast.mysticalwildlife.client.render.RenderVrontausaurus;
import lykrast.mysticalwildlife.client.render.RenderYagaHog;
import lykrast.mysticalwildlife.common.entity.EntityCicaptera;
import lykrast.mysticalwildlife.common.entity.EntityDuskLurker;
import lykrast.mysticalwildlife.common.entity.EntityKrill;
import lykrast.mysticalwildlife.common.entity.EntityPlumper;
import lykrast.mysticalwildlife.common.entity.EntityVrontausaurus;
import lykrast.mysticalwildlife.common.entity.EntityYagaHog;
import lykrast.mysticalwildlife.common.util.ModConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class ModEntities {
    private static int id = 1;
    private static List<EntityEntry> entityList = new ArrayList<EntityEntry>();

    public static void init() {
        EntityEntryBuilder<? extends Entity> builder = ModEntities.create(EntityVrontausaurus.class, "vrontausaurus", 0x515151, 0xD3D3D3);
        if (ModConfig.SPAWNING.vrontausaurus.weight > 0) {
            builder.spawn(EnumCreatureType.CREATURE, ModConfig.SPAWNING.vrontausaurus.weight, ModConfig.SPAWNING.vrontausaurus.minGroup, ModConfig.SPAWNING.vrontausaurus.maxGroup, (Iterable)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
        }
        ModEntities.register(builder);
        LootTableList.func_186375_a((ResourceLocation)EntityVrontausaurus.LOOT);
        LootTableList.func_186375_a((ResourceLocation)EntityVrontausaurus.LOOT_BRUSH);
        builder = ModEntities.create(EntityYagaHog.class, "yaga_hog", 10256223, 4469285);
        if (ModConfig.SPAWNING.yagaHog.weight > 0) {
            builder.spawn(EnumCreatureType.CREATURE, ModConfig.SPAWNING.yagaHog.weight, ModConfig.SPAWNING.yagaHog.minGroup, ModConfig.SPAWNING.yagaHog.maxGroup, (Iterable)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
        }
        ModEntities.register(builder);
        LootTableList.func_186375_a((ResourceLocation)EntityYagaHog.LOOT);
        LootTableList.func_186375_a((ResourceLocation)EntityYagaHog.LOOT_BRUSH);
        builder = ModEntities.create(EntityDuskLurker.class, "dusk_lurker", 0x262626, 0x808080);
        if (ModConfig.SPAWNING.duskLurkerForest.weight > 0) {
            builder.spawn(EnumCreatureType.CREATURE, ModConfig.SPAWNING.duskLurkerForest.weight, ModConfig.SPAWNING.duskLurkerForest.minGroup, ModConfig.SPAWNING.duskLurkerForest.maxGroup, (Iterable)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
        }
        if (ModConfig.SPAWNING.duskLurkerSpooky.weight > 0) {
            builder.spawn(EnumCreatureType.CREATURE, ModConfig.SPAWNING.duskLurkerSpooky.weight, ModConfig.SPAWNING.duskLurkerSpooky.minGroup, ModConfig.SPAWNING.duskLurkerSpooky.maxGroup, (Iterable)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY));
        }
        ModEntities.register(builder);
        LootTableList.func_186375_a((ResourceLocation)EntityDuskLurker.LOOT);
        LootTableList.func_186375_a((ResourceLocation)EntityDuskLurker.LOOT_BRUSH);
        builder = ModEntities.create(EntityCicaptera.Azure.class, "cicaptera_azure", 34007, 0x262626);
        if (ModConfig.SPAWNING.cicapteraAzure.weight > 0) {
            builder.spawn(EnumCreatureType.CREATURE, ModConfig.SPAWNING.cicapteraAzure.weight, ModConfig.SPAWNING.cicapteraAzure.minGroup, ModConfig.SPAWNING.cicapteraAzure.maxGroup, (Iterable)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
        }
        ModEntities.register(builder);
        LootTableList.func_186375_a((ResourceLocation)EntityCicaptera.Azure.LOOT);
        builder = ModEntities.create(EntityCicaptera.Verdant.class, "cicaptera_verdant", 5201960, 0x262626);
        if (ModConfig.SPAWNING.cicapteraVerdant.weight > 0) {
            builder.spawn(EnumCreatureType.CREATURE, ModConfig.SPAWNING.cicapteraVerdant.weight, ModConfig.SPAWNING.cicapteraVerdant.minGroup, ModConfig.SPAWNING.cicapteraVerdant.maxGroup, (Iterable)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
        }
        ModEntities.register(builder);
        LootTableList.func_186375_a((ResourceLocation)EntityCicaptera.Verdant.LOOT);
        builder = ModEntities.create(EntityCicaptera.Crimson.class, "cicaptera_crimson", 9120553, 0x262626);
        if (ModConfig.SPAWNING.cicapteraCrimson.weight > 0) {
            builder.spawn(EnumCreatureType.CREATURE, ModConfig.SPAWNING.cicapteraCrimson.weight, ModConfig.SPAWNING.cicapteraCrimson.minGroup, ModConfig.SPAWNING.cicapteraCrimson.maxGroup, (Iterable)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.HOT));
        }
        ModEntities.register(builder);
        LootTableList.func_186375_a((ResourceLocation)EntityCicaptera.Crimson.LOOT);
        builder = ModEntities.create(EntityCicaptera.Sandy.class, "cicaptera_sandy", 12433802, 0x262626);
        if (ModConfig.SPAWNING.cicapteraSandy.weight > 0) {
            builder.spawn(EnumCreatureType.CREATURE, ModConfig.SPAWNING.cicapteraSandy.weight, ModConfig.SPAWNING.cicapteraSandy.minGroup, ModConfig.SPAWNING.cicapteraSandy.maxGroup, (Iterable)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
        }
        ModEntities.register(builder);
        LootTableList.func_186375_a((ResourceLocation)EntityCicaptera.Sandy.LOOT);
        builder = ModEntities.create(EntityCicaptera.Wintry.class, "cicaptera_wintry", 13293527, 0x262626);
        if (ModConfig.SPAWNING.cicapteraWintry.weight > 0) {
            builder.spawn(EnumCreatureType.CREATURE, ModConfig.SPAWNING.cicapteraWintry.weight, ModConfig.SPAWNING.cicapteraWintry.minGroup, ModConfig.SPAWNING.cicapteraWintry.maxGroup, (Iterable)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SNOWY));
        }
        ModEntities.register(builder);
        LootTableList.func_186375_a((ResourceLocation)EntityCicaptera.Wintry.LOOT);
        builder = ModEntities.create(EntityCicaptera.Lovely.class, "cicaptera_lovely", 14640335, 0x262626);
        if (ModConfig.SPAWNING.cicapteraLovely.weight > 0) {
            builder.spawn(EnumCreatureType.CREATURE, ModConfig.SPAWNING.cicapteraLovely.weight, ModConfig.SPAWNING.cicapteraLovely.minGroup, ModConfig.SPAWNING.cicapteraLovely.maxGroup, ModEntities.getLovelyBiomes());
        }
        ModEntities.register(builder);
        LootTableList.func_186375_a((ResourceLocation)EntityCicaptera.Lovely.LOOT);
        builder = ModEntities.create(EntityPlumper.class, "plumper", 10130555, 7959649);
        if (ModConfig.SPAWNING.plumper.weight > 0) {
            builder.spawn(EnumCreatureType.CREATURE, ModConfig.SPAWNING.plumper.weight, ModConfig.SPAWNING.plumper.minGroup, ModConfig.SPAWNING.plumper.maxGroup, (Iterable)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.BEACH));
        }
        ModEntities.register(builder);
        LootTableList.func_186375_a((ResourceLocation)EntityPlumper.LOOT);
        builder = ModEntities.create(EntityKrill.class, "krill", 16541696, 16089088);
        if (ModConfig.SPAWNING.krill.weight > 0) {
            builder.spawn(EnumCreatureType.CREATURE, ModConfig.SPAWNING.krill.weight, ModConfig.SPAWNING.krill.minGroup, ModConfig.SPAWNING.krill.maxGroup, (Iterable)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.BEACH));
        }
        ModEntities.register(builder);
        LootTableList.func_186375_a((ResourceLocation)EntityKrill.LOOT);
        LootTableList.func_186375_a((ResourceLocation)EntityKrill.LOOT_FORAGE);
    }

    private static Set<Biome> getLovelyBiomes() {
        HashSet<Biome> set = new HashSet<Biome>();
        set.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL));
        set.add(Biomes.field_185441_Q);
        set.add(Biomes.field_185444_T);
        return set;
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        for (EntityEntry e : entityList) {
            event.getRegistry().register((IForgeRegistryEntry)e);
        }
        entityList = null;
    }

    public static void register(EntityEntryBuilder<? extends Entity> entry) {
        entityList.add(entry.build());
    }

    public static EntityEntryBuilder<? extends Entity> create(Class<? extends Entity> entityClass, String name, int colorBack, int colorFront) {
        EntityEntryBuilder builder = EntityEntryBuilder.create().entity(entityClass).name("mysticalwildlife." + name).id(new ResourceLocation("mysticalwildlife", name), id++).tracker(64, 3, true).egg(colorBack, colorFront);
        return builder;
    }

    @SideOnly(value=Side.CLIENT)
    public static void initModels() {
        RenderingRegistry.registerEntityRenderingHandler(EntityVrontausaurus.class, RenderVrontausaurus::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityYagaHog.class, RenderYagaHog::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityDuskLurker.class, RenderDuskLurker::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityCicaptera.Azure.class, RenderCicaptera.Azure::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityCicaptera.Verdant.class, RenderCicaptera.Verdant::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityCicaptera.Crimson.class, RenderCicaptera.Crimson::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityCicaptera.Sandy.class, RenderCicaptera.Sandy::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityCicaptera.Wintry.class, RenderCicaptera.Wintry::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityCicaptera.Lovely.class, RenderCicaptera.Lovely::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityPlumper.class, RenderPlumper::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityKrill.class, RenderKrill::new);
    }
}

