/*
 * Decompiled with CFR 0.152.
 */
package lykrast.mysticalwildlife.common.item;

import java.util.List;
import java.util.Random;
import lykrast.mysticalwildlife.common.entity.IBrushable;
import lykrast.mysticalwildlife.common.init.ModSounds;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class ItemBrush
extends Item {
    public ItemBrush(int damage) {
        this.func_77625_d(1);
        this.func_77656_e(damage);
    }

    @SubscribeEvent
    public static void onInteract(PlayerInteractEvent.EntityInteract evt) {
        ItemStack item;
        if (evt.getItemStack().func_77973_b() instanceof ItemBrush && evt.getTarget() instanceof EntityLivingBase && (item = evt.getItemStack()).func_77973_b().func_111207_a(item, evt.getEntityPlayer(), (EntityLivingBase)evt.getTarget(), evt.getHand())) {
            evt.setCanceled(true);
            evt.setCancellationResult(EnumActionResult.SUCCESS);
        }
    }

    public boolean func_111207_a(ItemStack itemstack, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        EntityTameable tameable;
        if (entity instanceof IBrushable) {
            IBrushable target = (IBrushable)entity;
            BlockPos pos = new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (target.isBrushable(player, itemstack, (IBlockAccess)entity.field_70170_p, pos)) {
                if (!entity.field_70170_p.field_72995_K) {
                    List<ItemStack> drops = target.onBrushed(player, itemstack, (IBlockAccess)entity.field_70170_p, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)itemstack));
                    if (!drops.isEmpty()) {
                        Random rand = new Random();
                        for (ItemStack stack : drops) {
                            EntityItem ent = entity.func_70099_a(stack, 1.0f);
                            ent.field_70181_x += (double)(rand.nextFloat() * 0.05f);
                            ent.field_70159_w += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                            ent.field_70179_y += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                        }
                    }
                    itemstack.func_77972_a(1, (EntityLivingBase)player);
                } else {
                    player.func_184609_a(hand);
                }
            }
            return true;
        }
        if (entity instanceof EntityTameable && (tameable = (EntityTameable)entity).func_70909_n()) {
            if (!tameable.field_70170_p.field_72995_K) {
                tameable.func_184185_a(ModSounds.brushing, 1.0f, 1.0f);
                tameable.field_70170_p.func_72960_a((Entity)tameable, (byte)7);
            } else {
                player.func_184609_a(hand);
            }
            return true;
        }
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.field_185308_t) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public int func_77619_b() {
        return 1;
    }
}

