/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2;

import com.someguyssoftware.gottschcore.GottschCore;
import com.someguyssoftware.gottschcore.annotation.Credits;
import com.someguyssoftware.gottschcore.command.ShowVersionCommand;
import com.someguyssoftware.gottschcore.config.IConfig;
import com.someguyssoftware.gottschcore.config.ILoggerConfig;
import com.someguyssoftware.gottschcore.mod.AbstractMod;
import com.someguyssoftware.gottschcore.mod.IMod;
import com.someguyssoftware.gottschcore.version.BuildVersion;
import com.someguyssoftware.treasure2.block.TreasureBlocks;
import com.someguyssoftware.treasure2.client.gui.GuiHandler;
import com.someguyssoftware.treasure2.command.SpawnChestCommand;
import com.someguyssoftware.treasure2.command.SpawnPitCommand;
import com.someguyssoftware.treasure2.command.SpawnPitOnlyCommand;
import com.someguyssoftware.treasure2.command.SpawnPitStructureOnlyCommand;
import com.someguyssoftware.treasure2.command.SpawnRuinsCommand;
import com.someguyssoftware.treasure2.command.SpawnWellStructureCommand;
import com.someguyssoftware.treasure2.command.SpawnWitherTreeCommand;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.enums.WorldGenerators;
import com.someguyssoftware.treasure2.eventhandler.LogoutEventHandler;
import com.someguyssoftware.treasure2.eventhandler.MimicEventHandler;
import com.someguyssoftware.treasure2.eventhandler.PlayerEventHandler;
import com.someguyssoftware.treasure2.eventhandler.WorldEventHandler;
import com.someguyssoftware.treasure2.item.PaintingItem;
import com.someguyssoftware.treasure2.item.TreasureItems;
import com.someguyssoftware.treasure2.loot.TreasureLootTableMaster;
import com.someguyssoftware.treasure2.meta.TreasureMetaManager;
import com.someguyssoftware.treasure2.world.gen.structure.TreasureDecayManager;
import com.someguyssoftware.treasure2.world.gen.structure.TreasureTemplateManager;
import com.someguyssoftware.treasure2.worldgen.GemOreWorldGenerator;
import com.someguyssoftware.treasure2.worldgen.ITreasureWorldGenerator;
import com.someguyssoftware.treasure2.worldgen.SubmergedChestWorldGenerator;
import com.someguyssoftware.treasure2.worldgen.SurfaceChestWorldGenerator;
import com.someguyssoftware.treasure2.worldgen.WellWorldGenerator;
import com.someguyssoftware.treasure2.worldgen.WitherTreeWorldGenerator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.datafix.DataFixer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;

@Mod(modid="treasure2", name="Treasure2", version="1.9.0", dependencies="required-after:gottschcore@[1.11.0,)", acceptedMinecraftVersions="[1.12.2]", updateJSON="https://raw.githubusercontent.com/gottsch/gottsch-minecraft-Treasure/master/Treasure2-1.12.2/update.json")
@Credits(values={"Treasure was first developed by Mark Gottschling on Aug 27, 2014.", "Treasure2 was first developed by Mark Gottschling on Jan 2018.", "Credits to Mason Gottschling for ideas and debugging.", "Credits to CuddleBeak for some Keys and Locks textures.", "Credits to mn_ti for Chinese and to DarkKnightComes for Polish translation.", "Credits to Mythical Sausage for tutorials on house/tower designs.", "Credits to OdinsRagnarok for Spanish translation and DarvinSlav for Russian translation."})
public class Treasure
extends AbstractMod {
    public static final String MODID = "treasure2";
    protected static final String NAME = "Treasure2";
    protected static final String VERSION = "1.9.0";
    public static final String UPDATE_JSON_URL = "https://raw.githubusercontent.com/gottsch/gottsch-minecraft-Treasure/master/Treasure2-1.12.2/update.json";
    private static final String VERSION_URL = "";
    private static final BuildVersion MINECRAFT_VERSION = new BuildVersion(1, 12, 2);
    private static BuildVersion latestVersion;
    public static Logger logger;
    @Mod.Instance(value="treasure2")
    public static Treasure instance;
    public static TreasureLootTableMaster LOOT_TABLES;
    public static CreativeTabs TREASURE_TAB;
    public static final Map<WorldGenerators, ITreasureWorldGenerator> WORLD_GENERATORS;
    public static TreasureTemplateManager TEMPLATE_MANAGER;
    public static TreasureMetaManager META_MANAGER;
    public static TreasureDecayManager DECAY_MANAGER;

    @Override
    @Mod.EventHandler
    public void preInt(FMLPreInitializationEvent event) {
        super.preInt(event);
        TreasureConfig cfr_ignored_0 = (TreasureConfig)this.getConfig();
        TreasureConfig.init();
        MinecraftForge.EVENT_BUS.register((Object)new LogoutEventHandler(this.getInstance()));
        MinecraftForge.EVENT_BUS.register((Object)new PlayerEventHandler(this.getInstance()));
        MinecraftForge.EVENT_BUS.register((Object)new WorldEventHandler(this.getInstance()));
        MinecraftForge.EVENT_BUS.register((Object)new MimicEventHandler(this.getInstance()));
        Appender appender = this.createRollingFileAppender(instance, "Treasure2Appender", (ILoggerConfig)((Object)this.getConfig()));
        this.addAppenderToLogger(appender, NAME, (ILoggerConfig)((Object)this.getConfig()));
        this.addAppenderToLogger(appender, GottschCore.instance.getName(), (ILoggerConfig)((Object)this.getConfig()));
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartingEvent event) {
        if (!this.getConfig().isModEnabled()) {
            return;
        }
        event.registerServerCommand((ICommand)new ShowVersionCommand(this));
        event.registerServerCommand((ICommand)new SpawnChestCommand());
        event.registerServerCommand((ICommand)new SpawnPitCommand());
        event.registerServerCommand((ICommand)new SpawnPitOnlyCommand());
        event.registerServerCommand((ICommand)new SpawnPitStructureOnlyCommand());
        event.registerServerCommand((ICommand)new SpawnWellStructureCommand());
        event.registerServerCommand((ICommand)new SpawnWitherTreeCommand());
        event.registerServerCommand((ICommand)new SpawnRuinsCommand());
    }

    @Override
    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (!this.getConfig().isModEnabled()) {
            return;
        }
        super.init(event);
        WORLD_GENERATORS.put(WorldGenerators.SURFACE_CHEST, new SurfaceChestWorldGenerator());
        WORLD_GENERATORS.put(WorldGenerators.SUBMERGED_CHEST, new SubmergedChestWorldGenerator());
        WORLD_GENERATORS.put(WorldGenerators.WELL, new WellWorldGenerator());
        WORLD_GENERATORS.put(WorldGenerators.WITHER_TREE, new WitherTreeWorldGenerator());
        WORLD_GENERATORS.put(WorldGenerators.GEM, new GemOreWorldGenerator());
        int genWeight = 0;
        for (Map.Entry<WorldGenerators, ITreasureWorldGenerator> gen : WORLD_GENERATORS.entrySet()) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)gen.getValue(), (int)genWeight++);
        }
        LOOT_TABLES = new TreasureLootTableMaster(instance, VERSION_URL, "loot_tables");
        TEMPLATE_MANAGER = new TreasureTemplateManager(instance, "/structures", (DataFixer)FMLCommonHandler.instance().getDataFixer());
        META_MANAGER = new TreasureMetaManager(instance, "meta");
        DECAY_MANAGER = new TreasureDecayManager(instance, "decay");
    }

    @Override
    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (!this.getConfig().isModEnabled()) {
            return;
        }
        super.postInit(event);
        OreDictionary.registerOre((String)"sapphire", (Item)TreasureItems.SAPPHIRE);
        OreDictionary.registerOre((String)"ruby", (Item)TreasureItems.RUBY);
        ((PaintingItem)TreasureItems.PAINTING_BLOCKS_BRICKS).setPaintingBlock(TreasureBlocks.PAINTING_BLOCKS_BRICKS);
        ((PaintingItem)TreasureItems.PAINTING_BLOCKS_COBBLESTONE).setPaintingBlock(TreasureBlocks.PAINTING_BLOCKS_COBBLESTONE);
        ((PaintingItem)TreasureItems.PAINTING_BLOCKS_DIRT).setPaintingBlock(TreasureBlocks.PAINTING_BLOCKS_DIRT);
        ((PaintingItem)TreasureItems.PAINTING_BLOCKS_LAVA).setPaintingBlock(TreasureBlocks.PAINTING_BLOCKS_LAVA);
        ((PaintingItem)TreasureItems.PAINTING_BLOCKS_SAND).setPaintingBlock(TreasureBlocks.PAINTING_BLOCKS_SAND);
        ((PaintingItem)TreasureItems.PAINTING_BLOCKS_WATER).setPaintingBlock(TreasureBlocks.PAINTING_BLOCKS_WATER);
        ((PaintingItem)TreasureItems.PAINTING_BLOCKS_WOOD).setPaintingBlock(TreasureBlocks.PAINTING_BLOCKS_WOOD);
        TreasureBlocks.PAINTING_BLOCKS_BRICKS.setItem((PaintingItem)TreasureItems.PAINTING_BLOCKS_BRICKS);
        TreasureBlocks.PAINTING_BLOCKS_COBBLESTONE.setItem((PaintingItem)TreasureItems.PAINTING_BLOCKS_COBBLESTONE);
        TreasureBlocks.PAINTING_BLOCKS_DIRT.setItem((PaintingItem)TreasureItems.PAINTING_BLOCKS_DIRT);
        TreasureBlocks.PAINTING_BLOCKS_LAVA.setItem((PaintingItem)TreasureItems.PAINTING_BLOCKS_LAVA);
        TreasureBlocks.PAINTING_BLOCKS_SAND.setItem((PaintingItem)TreasureItems.PAINTING_BLOCKS_SAND);
        TreasureBlocks.PAINTING_BLOCKS_WATER.setItem((PaintingItem)TreasureItems.PAINTING_BLOCKS_WATER);
        TreasureBlocks.PAINTING_BLOCKS_WOOD.setItem((PaintingItem)TreasureItems.PAINTING_BLOCKS_WOOD);
        TreasureBlocks.SAPPHIRE_ORE.setItem(TreasureItems.SAPPHIRE);
        TreasureBlocks.RUBY_ORE.setItem(TreasureItems.RUBY);
    }

    @Override
    public IConfig getConfig() {
        return TreasureConfig.instance;
    }

    @Override
    public BuildVersion getMinecraftVersion() {
        return MINECRAFT_VERSION;
    }

    @Override
    public String getVerisionURL() {
        return VERSION_URL;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getId() {
        return MODID;
    }

    @Override
    public IMod getInstance() {
        return instance;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public BuildVersion getModLatestVersion() {
        return latestVersion;
    }

    @Override
    public void setModLatestVersion(BuildVersion version) {
        latestVersion = version;
    }

    @Override
    public String getUpdateURL() {
        return UPDATE_JSON_URL;
    }

    static {
        logger = LogManager.getLogger((String)NAME);
        TREASURE_TAB = new CreativeTabs(CreativeTabs.getNextID(), "treasure2:treasure_tab"){

            @SideOnly(value=Side.CLIENT)
            public ItemStack func_78016_d() {
                return new ItemStack(TreasureItems.TREASURE_TAB, 1);
            }
        };
        WORLD_GENERATORS = new HashMap<WorldGenerators, ITreasureWorldGenerator>();
    }
}

