/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.block;

import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.AbstractChestBlock;
import com.someguyssoftware.treasure2.chest.TreasureChestType;
import com.someguyssoftware.treasure2.entity.monster.MimicEntity;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.tileentity.AbstractTreasureChestTileEntity;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class MimicChestBlock
extends AbstractChestBlock {
    private Class<? extends MimicEntity> mimicClass;

    public MimicChestBlock(String modID, String name, Class<? extends AbstractTreasureChestTileEntity> te, Class<? extends MimicEntity> mimic, TreasureChestType type, Rarity rarity) {
        this(modID, name, Material.field_151575_d, te, type, rarity);
        this.setMimicClass(mimic);
    }

    public MimicChestBlock(String modID, String name, Material material, Class<? extends AbstractTreasureChestTileEntity> te, TreasureChestType type, Rarity rarity) {
        super(modID, name, material, te, type, rarity);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        Treasure.logger.debug("Placing mimic from item");
        boolean shouldUpdate = false;
        boolean forceUpdate = false;
        AbstractTreasureChestTileEntity tcte = null;
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 3);
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof AbstractTreasureChestTileEntity) {
            tcte = (AbstractTreasureChestTileEntity)te;
            if (stack.func_82837_s()) {
                tcte.setCustomName(stack.func_82833_r());
            }
            tcte.setFacing(placer.func_174811_aO().func_176734_d().func_176745_a());
        }
        if ((forceUpdate || shouldUpdate) && tcte != null) {
            tcte.sendUpdates();
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        AbstractTreasureChestTileEntity te = (AbstractTreasureChestTileEntity)worldIn.func_175625_s(pos);
        if (WorldInfo.isClientSide(worldIn)) {
            return true;
        }
        EnumFacing chestFacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        float yaw = 0.0f;
        switch (chestFacing) {
            case NORTH: {
                yaw = 180.0f;
                break;
            }
            case EAST: {
                yaw = -90.0f;
                break;
            }
            case WEST: {
                yaw = 90.0f;
                break;
            }
            case SOUTH: {
                yaw = 0.0f;
            }
        }
        worldIn.func_175698_g(pos);
        EntityMob mimic = null;
        try {
            mimic = this.getMimicClass().getConstructor(World.class).newInstance(worldIn);
        }
        catch (Exception e) {
            Treasure.logger.error("Error creating mimic:", (Throwable)e);
        }
        if (mimic != null) {
            EntityMob entityLiving = mimic;
            entityLiving.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 45.0f, 0.0f);
            worldIn.func_72838_d((Entity)entityLiving);
            entityLiving.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 45.0f, 0.0f);
        }
        worldIn.func_175713_t(pos);
        return true;
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        super.func_180649_a(worldIn, pos, playerIn);
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        super.func_180652_a(worldIn, pos, explosionIn);
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public Class<? extends MimicEntity> getMimicClass() {
        return this.mimicClass;
    }

    public MimicChestBlock setMimicClass(Class<? extends MimicEntity> mimicClass) {
        this.mimicClass = mimicClass;
        return this;
    }
}

