/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.config;

import com.someguyssoftware.gottschcore.biome.BiomeHelper;
import com.someguyssoftware.gottschcore.biome.BiomeTypeHolder;
import com.someguyssoftware.treasure2.biome.TreasureBiomeHelper;
import com.someguyssoftware.treasure2.config.IBiomesConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.config.Config;

public class BiomesConfig
implements IBiomesConfig {
    @Config.Name(value="01. White list by biome name:")
    @Config.Comment(value={"Allowed Biomes for generation. Must match the Biome Name(s)."})
    public String[] rawBiomeWhiteList;
    @Config.Name(value="02. Black list by biome name:")
    @Config.Comment(value={"Disallowed Biomes for generation. Must match theBiome Name(s)."})
    public String[] rawBiomeBlackList;
    @Config.Name(value="03. White list by biome type:")
    @Config.Comment(value={"Allowabled Biome Types for generation. Must match the Type identifer(s)."})
    public String[] rawBiomeTypeWhiteList;
    @Config.Name(value="04. Black list by biome type")
    @Config.Comment(value={"Disallowed Biome Types for generation. Must match the Type identifer(s)."})
    public String[] rawBiomeTypeBlackList;
    @Config.Ignore
    public List<Biome> whiteList = new ArrayList<Biome>(5);
    @Config.Ignore
    public List<Biome> blackList = new ArrayList<Biome>(5);
    @Config.Ignore
    public List<BiomeTypeHolder> typeWhiteList = new ArrayList<BiomeTypeHolder>(5);
    @Config.Ignore
    public List<BiomeTypeHolder> typeBlackList = new ArrayList<BiomeTypeHolder>(5);

    public BiomesConfig(String[] whiteList, String[] blackList, String[] typeWhiteList, String[] typeBlackList) {
        this.rawBiomeWhiteList = whiteList;
        this.rawBiomeBlackList = blackList;
        this.rawBiomeTypeWhiteList = typeWhiteList;
        this.rawBiomeTypeBlackList = typeBlackList;
    }

    public void init() {
        this.whiteList = TreasureBiomeHelper.loadBiomesList(this.rawBiomeWhiteList);
        this.blackList = TreasureBiomeHelper.loadBiomesList(this.rawBiomeBlackList);
        BiomeHelper.loadBiomeList(this.rawBiomeTypeWhiteList, this.typeWhiteList);
        BiomeHelper.loadBiomeList(this.rawBiomeTypeBlackList, this.typeBlackList);
    }

    @Override
    public List<Biome> getWhiteList() {
        return this.whiteList;
    }

    @Override
    public void setWhiteList(List<Biome> whiteList) {
        this.whiteList = whiteList;
    }

    @Override
    public List<Biome> getBlackList() {
        return this.blackList;
    }

    @Override
    public void setBlackList(List<Biome> blackList) {
        this.blackList = blackList;
    }

    @Override
    public List<BiomeTypeHolder> getTypeWhiteList() {
        return this.typeWhiteList;
    }

    @Override
    public void setTypeWhiteList(List<BiomeTypeHolder> whiteList) {
    }

    @Override
    public List<BiomeTypeHolder> getTypeBlackList() {
        return this.typeBlackList;
    }

    @Override
    public void setTypeBlackList(List<BiomeTypeHolder> blackList) {
    }
}

