/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.enums;

import com.someguyssoftware.treasure2.enums.IEnum;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum Coins implements IEnum
{
    SILVER(0, "Silver Coin"),
    GOLD(1, "Gold Coin");

    private static final Map<Integer, IEnum> codes;
    private static final Map<String, IEnum> values;
    private Integer code;
    private String value;

    private Coins(Integer code, String value) {
        this.code = code;
        this.value = value;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public void setCode(Integer code) {
        this.code = code;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    public static Coins getByCode(Integer code) {
        return (Coins)codes.get(code);
    }

    public static Coins getByValue(String value) {
        return (Coins)values.get(value);
    }

    @Override
    public Map<Integer, IEnum> getCodes() {
        return codes;
    }

    @Override
    public Map<String, IEnum> getValues() {
        return values;
    }

    static {
        codes = new HashMap<Integer, IEnum>();
        values = new HashMap<String, IEnum>();
        for (Coins ps : EnumSet.allOf(Coins.class)) {
            codes.put(ps.getCode(), ps);
            values.put(ps.getValue(), ps);
        }
    }
}

