/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.eventhandler;

import com.someguyssoftware.gottschcore.mod.IMod;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.persistence.GenDataPersistence;
import com.someguyssoftware.treasure2.registry.ChestRegistry;
import com.someguyssoftware.treasure2.worldgen.ITreasureWorldGenerator;
import java.util.Map;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class WorldEventHandler {
    private IMod mod;

    public WorldEventHandler(IMod mod) {
        this.setMod(mod);
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (WorldInfo.isServerSide(event.getWorld()) && event.getWorld().field_73011_w.getDimension() == 0) {
            WorldServer world = (WorldServer)event.getWorld();
            Treasure.LOOT_TABLES.init(world);
            Treasure.LOOT_TABLES.register(this.getMod().getId());
            for (String foreignModID : TreasureConfig.FOREIGN_MODS.enableForeignModIDs) {
                if (!Loader.isModLoaded((String)foreignModID)) continue;
                Treasure.LOOT_TABLES.register(foreignModID);
            }
            Treasure.META_MANAGER.register(this.getMod().getId());
            Treasure.TEMPLATE_MANAGER.register(this.getMod().getId());
            Treasure.DECAY_MANAGER.register(this.getMod().getId());
            for (Map.Entry entry : Treasure.WORLD_GENERATORS.entrySet()) {
                ((ITreasureWorldGenerator)entry.getValue()).init();
            }
            Treasure.logger.debug("Chest registry size BEFORE cleaning -> {}", (Object)ChestRegistry.getInstance().getValues().size());
            ChestRegistry.getInstance().clear();
            Treasure.logger.debug("Chest registry size AFTER cleaning -> {}", (Object)ChestRegistry.getInstance().getValues().size());
            GenDataPersistence.get((World)world);
            Treasure.logger.debug("Chest registry size after world event load -> {}", (Object)ChestRegistry.getInstance().getValues().size());
        }
    }

    public IMod getMod() {
        return this.mod;
    }

    public void setMod(IMod mod) {
        this.mod = mod;
    }
}

