/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.generator.pit;

import com.someguyssoftware.gottschcore.measurement.Quantity;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.TreasureBlocks;
import com.someguyssoftware.treasure2.generator.ChestGeneratorData;
import com.someguyssoftware.treasure2.generator.GenUtil;
import com.someguyssoftware.treasure2.generator.GeneratorResult;
import com.someguyssoftware.treasure2.generator.pit.AbstractPitGenerator;
import com.someguyssoftware.treasure2.generator.pit.SimpleShortPitGenerator;
import com.someguyssoftware.treasure2.tileentity.ProximitySpawnerTileEntity;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.DungeonHooks;

public class BigBottomMobTrapPitGenerator
extends AbstractPitGenerator {
    public BigBottomMobTrapPitGenerator() {
        this.getBlockLayers().add(50, Blocks.field_150350_a);
        this.getBlockLayers().add(25, (Block)Blocks.field_150354_m);
        this.getBlockLayers().add(15, Blocks.field_150351_n);
        this.getBlockLayers().add(10, Blocks.field_150364_r);
    }

    @Override
    public GeneratorResult<ChestGeneratorData> generate(World world, Random random, ICoords surfaceCoords, ICoords spawnCoords) {
        GeneratorResult<ChestGeneratorData> result = new GeneratorResult<ChestGeneratorData>(ChestGeneratorData.class);
        result.getData().setSpawnCoords(spawnCoords);
        result.getData().setChestCoords(spawnCoords);
        boolean inCavern = false;
        IBlockState blockState = world.func_180495_p(spawnCoords.add(0, 1, 0).toPos());
        if (blockState == null || blockState.func_185904_a() == Material.field_151579_a) {
            Treasure.logger.debug("Spawn coords is in cavern.");
            inCavern = true;
        }
        if (inCavern) {
            Treasure.logger.debug("Shaft is in cavern... finding ceiling.");
            spawnCoords = GenUtil.findUndergroundCeiling(world, spawnCoords.add(0, 1, 0));
            if (spawnCoords == null) {
                Treasure.logger.warn("Exiting: Unable to locate cavern ceiling.");
                return result.fail();
            }
            result.getData().setSpawnCoords(spawnCoords);
            result.getData().setChestCoords(spawnCoords);
        }
        int yDist = surfaceCoords.getY() - spawnCoords.getY() - 2;
        Treasure.logger.debug("Distance to ySurface =" + yDist);
        ICoords nextCoords = null;
        if (yDist > 6) {
            Treasure.logger.debug("Generating shaft @ " + spawnCoords.toShortString());
            nextCoords = this.build6WideLayer(world, random, spawnCoords, Blocks.field_150350_a);
            nextCoords = this.build6WideLayer(world, random, nextCoords, Blocks.field_150350_a);
            nextCoords = this.build6WideLayer(world, random, nextCoords, Blocks.field_150350_a);
            nextCoords = this.buildLogLayer(world, random, nextCoords, Blocks.field_150364_r);
            nextCoords = this.buildLayer(world, nextCoords, (Block)Blocks.field_150354_m);
            this.buildLogLayer(world, random, surfaceCoords.add(0, -3, 0), Blocks.field_150364_r);
            this.buildLayer(world, surfaceCoords.add(0, -4, 0), (Block)Blocks.field_150354_m);
            this.buildLogLayer(world, random, surfaceCoords.add(0, -5, 0), Blocks.field_150364_r);
            this.buildTrapLayer(world, random, spawnCoords, null);
            this.buildPit(world, random, nextCoords.down(5), surfaceCoords, this.getBlockLayers());
        } else if (yDist >= 2) {
            result = new SimpleShortPitGenerator().generate(world, random, surfaceCoords, spawnCoords);
        }
        Treasure.logger.debug("Generated Big Bottom Mob Trap Pit at " + spawnCoords.toShortString());
        return result.success();
    }

    private ICoords build6WideLayer(World world, Random random, ICoords coords, Block block) {
        ICoords startCoords = coords.add(-2, 0, -2);
        for (int x = startCoords.getX(); x < startCoords.getX() + 6; ++x) {
            for (int z = startCoords.getZ(); z < startCoords.getZ() + 6; ++z) {
                GenUtil.replaceWithBlockState(world, new Coords(x, coords.getY(), z), block.func_176223_P());
            }
        }
        return coords.add(0, 1, 0);
    }

    public ICoords buildTrapLayer(World world, Random random, ICoords coords, Block block) {
        world.func_175656_a(coords.add(-1, 0, 0).toPos(), TreasureBlocks.PROXIMITY_SPAWNER.func_176223_P());
        ProximitySpawnerTileEntity te = (ProximitySpawnerTileEntity)world.func_175625_s(coords.add(-1, 0, 0).toPos());
        ResourceLocation r = DungeonHooks.getRandomDungeonMob((Random)random);
        te.setMobName(r);
        te.setMobNum(new Quantity(2.0, 4.0));
        te.setProximity(5.0);
        te.setSpawnRange(1.5);
        Treasure.logger.debug("placed proximity spawner @ {}", (Object)coords.add(-1, 0, 0).toShortString());
        world.func_175656_a(coords.add(1, 0, 0).toPos(), TreasureBlocks.PROXIMITY_SPAWNER.func_176223_P());
        te = (ProximitySpawnerTileEntity)world.func_175625_s(coords.add(1, 0, 0).toPos());
        r = DungeonHooks.getRandomDungeonMob((Random)random);
        te.setMobName(r);
        te.setMobNum(new Quantity(2.0, 4.0));
        te.setProximity(5.5);
        te.setSpawnRange(2.0);
        Treasure.logger.debug("placed proximity spawner @ {}", (Object)coords.add(1, 0, 0).toShortString());
        return coords;
    }
}

