/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.generator.pit;

import com.someguyssoftware.gottschcore.cube.Cube;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.random.RandomWeightedCollection;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.generator.ChestGeneratorData;
import com.someguyssoftware.treasure2.generator.GenUtil;
import com.someguyssoftware.treasure2.generator.GeneratorResult;
import com.someguyssoftware.treasure2.generator.pit.AbstractPitGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class MobTrapPitGenerator
extends AbstractPitGenerator {
    public MobTrapPitGenerator() {
        this.getBlockLayers().add(50, Blocks.field_150350_a);
        this.getBlockLayers().add(25, (Block)Blocks.field_150354_m);
        this.getBlockLayers().add(15, Blocks.field_150347_e);
        this.getBlockLayers().add(10, Blocks.field_150364_r);
    }

    @Override
    public GeneratorResult<ChestGeneratorData> generate(World world, Random random, ICoords surfaceCoords, ICoords spawnCoords) {
        GeneratorResult<ChestGeneratorData> result = super.generate(world, random, surfaceCoords, spawnCoords);
        if (result.isSuccess()) {
            Treasure.logger.debug("Generated Mob Trap Pit at " + spawnCoords.toShortString());
        }
        return result;
    }

    @Override
    public ICoords buildPit(World world, Random random, ICoords coords, ICoords surfaceCoords, RandomWeightedCollection<Block> col) {
        ICoords nextCoords = null;
        ICoords expectedCoords = null;
        int midY = (surfaceCoords.getY() + coords.getY()) / 2;
        Coords midCoords = new Coords(coords.getX(), midY, coords.getZ());
        int deltaY = surfaceCoords.delta(midCoords).getY();
        for (int yIndex = coords.getY() + this.getOffsetY(); yIndex <= surfaceCoords.getY() - 6; ++yIndex) {
            Block block;
            Cube cube = new Cube(world, new Coords(coords.getX(), yIndex, coords.getZ()));
            if (cube.isAir()) continue;
            nextCoords = yIndex == midCoords.getY() && deltaY > 4 ? this.buildTrapLayer(world, random, cube.getCoords(), Blocks.field_150364_r) : ((block = col.next()) == Blocks.field_150364_r ? this.buildLogLayer(world, random, cube.getCoords(), block) : this.buildLayer(world, cube.getCoords(), block));
            expectedCoords = cube.getCoords().add(0, 1, 0);
            yIndex = this.autoCorrectIndex(yIndex, nextCoords, expectedCoords);
        }
        return nextCoords;
    }

    public ICoords buildTrapLayer(World world, Random random, ICoords coords, Block block) {
        ICoords nextCoords = null;
        nextCoords = block == Blocks.field_150364_r ? this.buildLogLayer(world, random, coords, block) : this.buildLayer(world, coords, block);
        ICoords spawnCoords = nextCoords;
        GenUtil.replaceWithBlock(world, nextCoords.add(0, 0, 0), Blocks.field_150350_a);
        GenUtil.replaceWithBlock(world, nextCoords.add(1, 0, 0), Blocks.field_150350_a);
        GenUtil.replaceWithBlock(world, nextCoords.add(0, 0, 1), Blocks.field_150350_a);
        GenUtil.replaceWithBlock(world, nextCoords.add(1, 0, 1), Blocks.field_150350_a);
        nextCoords = nextCoords.up(1);
        GenUtil.replaceWithBlock(world, nextCoords.add(0, 0, 0), Blocks.field_150350_a);
        GenUtil.replaceWithBlock(world, nextCoords.add(1, 0, 0), Blocks.field_150350_a);
        GenUtil.replaceWithBlock(world, nextCoords.add(0, 0, 1), Blocks.field_150350_a);
        GenUtil.replaceWithBlock(world, nextCoords.add(1, 0, 1), Blocks.field_150350_a);
        nextCoords = this.buildLogLayer(world, random, nextCoords, block);
        this.spawnRandomMob(world, random, spawnCoords);
        this.spawnRandomMob(world, random, spawnCoords.add(1, 0, 0));
        this.spawnRandomMob(world, random, spawnCoords.add(0, 0, 1));
        this.spawnRandomMob(world, random, spawnCoords.add(1, 0, 1));
        nextCoords = nextCoords.up(1);
        return nextCoords;
    }
}

