/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.generator.pit;

import com.someguyssoftware.gottschcore.measurement.Quantity;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.world.gen.structure.GottschTemplate;
import com.someguyssoftware.gottschcore.world.gen.structure.StructureMarkers;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.TreasureBlocks;
import com.someguyssoftware.treasure2.generator.ChestGeneratorData;
import com.someguyssoftware.treasure2.generator.GenUtil;
import com.someguyssoftware.treasure2.generator.GeneratorResult;
import com.someguyssoftware.treasure2.generator.IGeneratorResult;
import com.someguyssoftware.treasure2.generator.TemplateGeneratorData;
import com.someguyssoftware.treasure2.generator.pit.AbstractPitGenerator;
import com.someguyssoftware.treasure2.generator.pit.IPitGenerator;
import com.someguyssoftware.treasure2.generator.pit.SimpleShortPitGenerator;
import com.someguyssoftware.treasure2.meta.StructureArchetype;
import com.someguyssoftware.treasure2.meta.StructureType;
import com.someguyssoftware.treasure2.tileentity.AbstractProximityTileEntity;
import com.someguyssoftware.treasure2.tileentity.ProximitySpawnerTileEntity;
import com.someguyssoftware.treasure2.world.gen.structure.TemplateGenerator;
import com.someguyssoftware.treasure2.world.gen.structure.TemplateHolder;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraftforge.common.DungeonHooks;

public class StructurePitGenerator
extends AbstractPitGenerator {
    private IPitGenerator<GeneratorResult<ChestGeneratorData>> generator;

    public StructurePitGenerator() {
    }

    public StructurePitGenerator(IPitGenerator<GeneratorResult<ChestGeneratorData>> generator) {
        this();
        this.setGenerator(generator);
        Treasure.logger.debug("using parent generator -> {}", (Object)generator.getClass().getSimpleName());
    }

    @Override
    public boolean generateEntrance(World world, Random random, ICoords surfaceCoords, ICoords spawnCoords) {
        return this.getGenerator().generateEntrance(world, random, surfaceCoords, spawnCoords);
    }

    @Override
    public boolean generatePit(World world, Random random, ICoords surfaceCoords, ICoords spawnCoords) {
        this.getGenerator().setOffsetY(0);
        return this.getGenerator().generatePit(world, random, surfaceCoords, spawnCoords);
    }

    @Override
    public GeneratorResult<ChestGeneratorData> generate(World world, Random random, ICoords surfaceCoords, ICoords spawnCoords) {
        GeneratorResult<ChestGeneratorData> result = new GeneratorResult<ChestGeneratorData>(ChestGeneratorData.class);
        boolean inCavern = false;
        IBlockState blockState = world.func_180495_p(spawnCoords.add(0, 1, 0).toPos());
        if (blockState == null || blockState.func_185904_a() == Material.field_151579_a) {
            Treasure.logger.debug("Spawn coords is in cavern.");
            inCavern = true;
        }
        if (inCavern) {
            Treasure.logger.debug("Shaft is in cavern... finding ceiling.");
            spawnCoords = GenUtil.findUndergroundCeiling(world, spawnCoords.add(0, 1, 0));
            if (spawnCoords == null) {
                Treasure.logger.warn("Exiting: Unable to locate cavern ceiling.");
                return result.fail();
            }
            result.getData().setSpawnCoords(spawnCoords);
        }
        int yDist = surfaceCoords.getY() - spawnCoords.getY() - 2;
        Treasure.logger.debug("Distance to ySurface =" + yDist);
        if (yDist > 6) {
            ResourceLocation r;
            Object te;
            Treasure.logger.debug("generating structure room at -> {}", (Object)spawnCoords.toShortString());
            String key = StructureArchetype.SUBTERRANEAN.getName() + ":" + StructureType.ROOM.getName();
            Biome biome = world.func_180494_b(spawnCoords.toPos());
            Integer biomeID = Biome.func_185362_a((Biome)biome);
            List templateHolders = (List)Treasure.TEMPLATE_MANAGER.getTemplatesByArchetypeTypeBiomeTable().get((Object)key, (Object)biomeID);
            if (templateHolders == null || templateHolders.isEmpty()) {
                Treasure.logger.debug("could not find template holders for archetype:type, biome -> {} [{}]:[]", (Object)key, (Object)biomeID, (Object)biome.toString());
                return result.fail();
            }
            TemplateHolder holder = (TemplateHolder)templateHolders.get(random.nextInt(templateHolders.size()));
            if (holder == null) {
                Treasure.logger.debug("could not find random template holder.");
                return result.fail();
            }
            GottschTemplate template = (GottschTemplate)holder.getTemplate();
            Treasure.logger.debug("selected template holder -> {} : {}", (Object)holder.getLocation(), (Object)holder.getMetaLocation());
            if (template == null) {
                Treasure.logger.debug("could not find random template");
                return result.fail();
            }
            int offset = 0;
            ICoords offsetCoords = template.findCoords(random, GenUtil.getMarkerBlock(StructureMarkers.OFFSET));
            if (offsetCoords != null) {
                offset = -offsetCoords.getY();
            }
            BlockPos size = template.func_186259_a();
            Treasure.logger.debug("template size -> {}, offset -> {}", (Object)size, (Object)offset);
            if (size.func_177956_o() + offset + 3 >= yDist) {
                Treasure.logger.debug("Structure's height is too large for available space.");
                result = this.getGenerator().generate(world, random, surfaceCoords, spawnCoords);
                if (result.isSuccess()) {
                    result.getData().setChestCoords(result.getData().getSpawnCoords());
                    return result;
                }
                Treasure.logger.debug("Unable to generate base pit.");
                return result.fail();
            }
            ICoords entranceCoords = template.findCoords(random, GenUtil.getMarkerBlock(StructureMarkers.ENTRANCE));
            if (entranceCoords == null) {
                Treasure.logger.debug("Unable to locate entrance position.");
                return result.fail();
            }
            Rotation rotation = Rotation.values()[random.nextInt(Rotation.values().length)];
            Treasure.logger.debug("rotation used -> {}", (Object)rotation);
            PlacementSettings placement = new PlacementSettings();
            placement.func_186220_a(rotation).func_189950_a(random);
            Coords newEntrance = new Coords(GottschTemplate.func_186266_a((PlacementSettings)placement, (BlockPos)entranceCoords.toPos()));
            BlockPos transformedSize = template.func_186257_a(rotation);
            ICoords roomCoords = this.alignToPit(spawnCoords, newEntrance, transformedSize, placement);
            Treasure.logger.debug("aligned room coords -> {}", (Object)roomCoords.toShortString());
            IGeneratorResult genResult = new TemplateGenerator().generate(world, random, holder, placement, roomCoords);
            if (!((GeneratorResult)genResult).isSuccess()) {
                return result.fail();
            }
            result.setData((ChestGeneratorData)((GeneratorResult)genResult).getData());
            List spawnerCoords = (List)((TemplateGeneratorData)((GeneratorResult)genResult).getData()).getMap().get((Object)GenUtil.getMarkerBlock(StructureMarkers.SPAWNER));
            List proximityCoords = (List)((TemplateGeneratorData)((GeneratorResult)genResult).getData()).getMap().get((Object)GenUtil.getMarkerBlock(StructureMarkers.PROXIMITY_SPAWNER));
            for (ICoords c : spawnerCoords) {
                world.func_175656_a(c.toPos(), Blocks.field_150474_ac.func_176223_P());
                te = (TileEntityMobSpawner)world.func_175625_s(c.toPos());
                r = DungeonHooks.getRandomDungeonMob((Random)random);
                te.func_145881_a().func_190894_a(r);
            }
            for (ICoords c : proximityCoords) {
                world.func_175656_a(c.toPos(), TreasureBlocks.PROXIMITY_SPAWNER.func_176223_P());
                te = (ProximitySpawnerTileEntity)world.func_175625_s(c.toPos());
                r = DungeonHooks.getRandomDungeonMob((Random)random);
                ((ProximitySpawnerTileEntity)te).setMobName(r);
                ((ProximitySpawnerTileEntity)te).setMobNum(new Quantity(1.0, 2.0));
                ((AbstractProximityTileEntity)te).setProximity(5.0);
            }
            this.generateEntrance(world, random, surfaceCoords, spawnCoords.add(0, size.func_177956_o() + 1, 0));
            this.generatePit(world, random, surfaceCoords, spawnCoords.add(0, size.func_177956_o(), 0));
        } else if (yDist >= 2) {
            result = new SimpleShortPitGenerator().generate(world, random, surfaceCoords, spawnCoords);
        }
        Treasure.logger.debug("Generated Structure Pit at " + spawnCoords.toShortString());
        return result.success();
    }

    private ICoords alignToPit(ICoords spawnCoords, ICoords newEntrance, BlockPos transformedSize, PlacementSettings placement) {
        ICoords startCoords = null;
        startCoords = spawnCoords.add(-newEntrance.getX(), 0, -newEntrance.getZ());
        switch (placement.func_186215_c()) {
            case CLOCKWISE_90: {
                startCoords = startCoords.add(1, 0, 0);
                break;
            }
            case CLOCKWISE_180: {
                startCoords = startCoords.add(1, 0, 1);
                break;
            }
            case COUNTERCLOCKWISE_90: {
                startCoords = startCoords.add(0, 0, 1);
                break;
            }
        }
        return startCoords;
    }

    public IPitGenerator<GeneratorResult<ChestGeneratorData>> getGenerator() {
        return this.generator;
    }

    public void setGenerator(IPitGenerator<GeneratorResult<ChestGeneratorData>> generator) {
        this.generator = generator;
    }
}

