/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.generator.ruins;

import com.someguyssoftware.gottschcore.measurement.Quantity;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.gottschcore.world.gen.structure.DecayProcessor;
import com.someguyssoftware.gottschcore.world.gen.structure.IDecayRuleSet;
import com.someguyssoftware.gottschcore.world.gen.structure.StructureMarkers;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.generator.GenUtil;
import com.someguyssoftware.treasure2.generator.GeneratorResult;
import com.someguyssoftware.treasure2.generator.IGeneratorResult;
import com.someguyssoftware.treasure2.generator.TemplateGeneratorData;
import com.someguyssoftware.treasure2.generator.ruins.IRuinGenerator;
import com.someguyssoftware.treasure2.meta.StructureArchetype;
import com.someguyssoftware.treasure2.meta.StructureMeta;
import com.someguyssoftware.treasure2.meta.StructureType;
import com.someguyssoftware.treasure2.world.gen.structure.TemplateGenerator;
import com.someguyssoftware.treasure2.world.gen.structure.TemplateHolder;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.Rotation;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;

public class SubmergedRuinGenerator
implements IRuinGenerator<GeneratorResult<TemplateGeneratorData>> {
    private static final double REQUIRED_BASE_SIZE = 50.0;

    @Override
    public GeneratorResult<TemplateGeneratorData> generate(World world, Random random, ICoords originalSpawnCoords) {
        return this.generate(world, random, originalSpawnCoords, null, null);
    }

    @Override
    public GeneratorResult<TemplateGeneratorData> generate(World world, Random random, ICoords originalSpawnCoords, IDecayRuleSet decayRuleSet) {
        return this.generate(world, random, originalSpawnCoords, null, decayRuleSet);
    }

    @Override
    public GeneratorResult<TemplateGeneratorData> generate(World world, Random random, ICoords originalSpawnCoords, TemplateHolder holder) {
        return this.generate(world, random, originalSpawnCoords, holder, null);
    }

    @Override
    public GeneratorResult<TemplateGeneratorData> generate(World world, Random random, ICoords originalSpawnCoords, TemplateHolder holder, IDecayRuleSet decayRuleSet) {
        IGeneratorResult genResult;
        GeneratorResult<TemplateGeneratorData> result = new GeneratorResult<TemplateGeneratorData>(TemplateGeneratorData.class);
        TemplateGenerator generator = new TemplateGenerator();
        generator.setNullBlock(Blocks.field_150350_a);
        if (holder == null) {
            holder = this.selectTemplate(world, random, originalSpawnCoords, StructureArchetype.SUBMERGED, StructureType.RUIN);
        }
        if (holder == null) {
            return result.fail();
        }
        Rotation rotation = Rotation.values()[random.nextInt(Rotation.values().length)];
        Treasure.logger.debug("rotation used -> {}", (Object)rotation);
        PlacementSettings placement = new PlacementSettings();
        placement.func_186220_a(rotation).func_189950_a(random);
        Coords templateSize = new Coords(holder.getTemplate().func_186257_a(placement.func_186215_c()));
        ICoords actualSpawnCoords = generator.getTransformedSpawnCoords(originalSpawnCoords, templateSize, placement);
        actualSpawnCoords = WorldInfo.getOceanFloorSurfaceCoords(world, actualSpawnCoords);
        Treasure.logger.debug("ocean floor coords -> {}", (Object)actualSpawnCoords.toShortString());
        for (int i = 0; i < 3 && !WorldInfo.isSolidBase(world, actualSpawnCoords, templateSize.getX(), templateSize.getZ(), 50.0); ++i) {
            if (i == 2) {
                Treasure.logger.debug("Coords -> [{}] does not meet {}% solid base requirements for size -> {} x {}", (Object)50.0, (Object)originalSpawnCoords.toShortString(), (Object)templateSize.getX(), (Object)templateSize.getY());
                return result.fail();
            }
            actualSpawnCoords = actualSpawnCoords.add(0, -1, 0);
        }
        originalSpawnCoords = new Coords(originalSpawnCoords.getX(), actualSpawnCoords.getY(), originalSpawnCoords.getZ());
        StructureMeta meta = (StructureMeta)Treasure.META_MANAGER.getMetaMap().get(holder.getMetaLocation().toString());
        if (meta == null) {
            Treasure.logger.debug("Unable to locate meta data for template -> {}", (Object)holder.getLocation());
            return result.fail();
        }
        DecayProcessor decayProcessor = null;
        if (decayRuleSet == null && holder.getDecayRuleSetLocation() != null && holder.getDecayRuleSetLocation().size() > 0) {
            decayRuleSet = Treasure.DECAY_MANAGER.getRuleSetMap().get(holder.getDecayRuleSetLocation().get(random.nextInt(holder.getDecayRuleSetLocation().size())).toString());
            Treasure.logger.debug("decayRuleSet -> {}", (Object)decayRuleSet.getName());
        }
        if (decayRuleSet != null) {
            decayProcessor = new DecayProcessor(Treasure.instance.getInstance(), decayRuleSet);
            decayProcessor.setBackFillBlockLayer1(Blocks.field_150351_n.func_176223_P());
        }
        if (!((GeneratorResult)(genResult = generator.generate(world, random, decayProcessor, holder, placement, originalSpawnCoords))).isSuccess()) {
            return result.fail();
        }
        Treasure.logger.debug("submerged gen result -> {}", (Object)genResult);
        List spawnerCoords = (List)((TemplateGeneratorData)((GeneratorResult)genResult).getData()).getMap().get((Object)GenUtil.getMarkerBlock(StructureMarkers.SPAWNER));
        List proximityCoords = (List)((TemplateGeneratorData)((GeneratorResult)genResult).getData()).getMap().get((Object)GenUtil.getMarkerBlock(StructureMarkers.PROXIMITY_SPAWNER));
        this.buildVanillaSpawners(world, random, spawnerCoords);
        this.buildOneTimeSpawners(world, random, proximityCoords, new Quantity(1.0, 2.0), 5.0);
        result.setData((TemplateGeneratorData)((GeneratorResult)genResult).getData());
        return result.success();
    }
}

