/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.generator.ruins;

import com.someguyssoftware.gottschcore.measurement.Quantity;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.gottschcore.world.gen.structure.DecayProcessor;
import com.someguyssoftware.gottschcore.world.gen.structure.IDecayRuleSet;
import com.someguyssoftware.gottschcore.world.gen.structure.StructureMarkers;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.generator.GenUtil;
import com.someguyssoftware.treasure2.generator.GeneratorResult;
import com.someguyssoftware.treasure2.generator.IGeneratorResult;
import com.someguyssoftware.treasure2.generator.TemplateGeneratorData;
import com.someguyssoftware.treasure2.generator.ruins.IRuinGenerator;
import com.someguyssoftware.treasure2.meta.StructureArchetype;
import com.someguyssoftware.treasure2.meta.StructureMeta;
import com.someguyssoftware.treasure2.meta.StructureType;
import com.someguyssoftware.treasure2.world.gen.structure.TemplateGenerator;
import com.someguyssoftware.treasure2.world.gen.structure.TemplateHolder;
import java.util.List;
import java.util.Random;
import net.minecraft.util.Rotation;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;

public class SurfaceRuinGenerator
implements IRuinGenerator<GeneratorResult<TemplateGeneratorData>> {
    private static final double REQUIRED_BASE_SIZE = 45.0;
    private static final double REQUIRED_AIR_SIZE = 30.0;

    @Override
    public GeneratorResult<TemplateGeneratorData> generate(World world, Random random, ICoords originalSpawnCoords) {
        return this.generate(world, random, originalSpawnCoords, null, null);
    }

    @Override
    public GeneratorResult<TemplateGeneratorData> generate(World world, Random random, ICoords originalSpawnCoords, IDecayRuleSet decayRuleSet) {
        return this.generate(world, random, originalSpawnCoords, null, decayRuleSet);
    }

    @Override
    public GeneratorResult<TemplateGeneratorData> generate(World world, Random random, ICoords originalSpawnCoords, TemplateHolder holder) {
        return this.generate(world, random, originalSpawnCoords, holder, null);
    }

    @Override
    public GeneratorResult<TemplateGeneratorData> generate(World world, Random random, ICoords originalSpawnCoords, TemplateHolder holder, IDecayRuleSet decayRuleSet) {
        IGeneratorResult genResult;
        GeneratorResult<TemplateGeneratorData> result = new GeneratorResult<TemplateGeneratorData>(TemplateGeneratorData.class);
        TemplateGenerator generator = new TemplateGenerator();
        if (holder == null) {
            holder = this.selectTemplate(world, random, originalSpawnCoords, StructureArchetype.SURFACE, StructureType.RUIN);
        }
        if (holder == null) {
            return result.fail();
        }
        Rotation rotation = Rotation.values()[random.nextInt(Rotation.values().length)];
        Treasure.logger.debug("rotation used -> {}", (Object)rotation);
        PlacementSettings placement = new PlacementSettings();
        placement.func_186220_a(rotation).func_189950_a(random);
        Coords templateSize = new Coords(holder.getTemplate().func_186257_a(placement.func_186215_c()));
        ICoords actualSpawnCoords = generator.getTransformedSpawnCoords(originalSpawnCoords, templateSize, placement);
        Treasure.logger.debug("original coords -> {}", (Object)originalSpawnCoords.toShortString());
        Treasure.logger.debug("actual coords -> {}", (Object)actualSpawnCoords.toShortString());
        actualSpawnCoords = WorldInfo.getDryLandSurfaceCoords(world, actualSpawnCoords);
        Treasure.logger.debug("surface coords -> {}", (Object)actualSpawnCoords.toShortString());
        if (actualSpawnCoords == WorldInfo.EMPTY_COORDS) {
            return result.fail();
        }
        for (int i = 0; i < 3; ++i) {
            Treasure.logger.debug("finding solid base index -> {} at coords -> {}", (Object)i, (Object)actualSpawnCoords.toShortString());
            if (WorldInfo.isSolidBase(world, actualSpawnCoords, templateSize.getX(), templateSize.getZ(), 45.0)) break;
            if (i == 2) {
                Treasure.logger.debug("Coords -> [{}] does not meet {}% solid base requirements for size -> {} x {}", (Object)originalSpawnCoords.toShortString(), (Object)45.0, (Object)templateSize.getX(), (Object)templateSize.getZ());
                return result.fail();
            }
            actualSpawnCoords = actualSpawnCoords.add(0, -1, 0);
            Treasure.logger.debug("move actual spawn coords down for solid base check -> {}", (Object)actualSpawnCoords.toShortString());
        }
        Treasure.logger.debug("using solid base coords -> {}", (Object)actualSpawnCoords.toShortString());
        Treasure.logger.debug("checking for {} % air at coords -> {} for dimensions -> {} x {}", (Object)30.0, (Object)actualSpawnCoords.add(0, 1, 0), (Object)templateSize.getX(), (Object)templateSize.getZ());
        if (!WorldInfo.isAirBase(world, actualSpawnCoords.add(0, 1, 0), templateSize.getX(), templateSize.getZ(), 30.0)) {
            Treasure.logger.debug("Coords -> [{}] does not meet {} % air base requirements for size -> {} x {}", (Object)originalSpawnCoords.toShortString(), (Object)30.0, (Object)templateSize.getX(), (Object)templateSize.getZ());
            return result.fail();
        }
        originalSpawnCoords = new Coords(originalSpawnCoords.getX(), actualSpawnCoords.getY(), originalSpawnCoords.getZ());
        StructureMeta meta = (StructureMeta)Treasure.META_MANAGER.getMetaMap().get(holder.getMetaLocation().toString());
        if (meta == null) {
            Treasure.logger.debug("Unable to locate meta data for template -> {}", (Object)holder.getLocation());
            return result.fail();
        }
        DecayProcessor decayProcessor = null;
        if (decayRuleSet == null && holder.getDecayRuleSetLocation() != null && holder.getDecayRuleSetLocation().size() > 0) {
            decayRuleSet = Treasure.DECAY_MANAGER.getRuleSetMap().get(holder.getDecayRuleSetLocation().get(random.nextInt(holder.getDecayRuleSetLocation().size())).toString());
            Treasure.logger.debug("decayRuleSet -> {}", (Object)decayRuleSet.getName());
        }
        if (decayRuleSet != null) {
            decayProcessor = new DecayProcessor(Treasure.instance.getInstance(), decayRuleSet);
        }
        if (!((GeneratorResult)(genResult = generator.generate(world, random, decayProcessor, holder, placement, originalSpawnCoords))).isSuccess()) {
            return result.fail();
        }
        Treasure.logger.debug("surface gen result -> {}", (Object)genResult);
        ICoords chestCoords = ((TemplateGeneratorData)((GeneratorResult)genResult).getData()).getChestCoords();
        if (chestCoords != null && (chestCoords = WorldInfo.getDryLandSurfaceCoords(world, chestCoords)) == WorldInfo.EMPTY_COORDS) {
            chestCoords = null;
        }
        ((TemplateGeneratorData)((GeneratorResult)genResult).getData()).setChestCoords(chestCoords);
        List spawnerCoords = (List)((TemplateGeneratorData)((GeneratorResult)genResult).getData()).getMap().get((Object)GenUtil.getMarkerBlock(StructureMarkers.SPAWNER));
        List proximityCoords = (List)((TemplateGeneratorData)((GeneratorResult)genResult).getData()).getMap().get((Object)GenUtil.getMarkerBlock(StructureMarkers.PROXIMITY_SPAWNER));
        if (proximityCoords != null) {
            Treasure.logger.debug("Proximity spawners size -> {}", (Object)proximityCoords.size());
        } else {
            Treasure.logger.debug("No proximity spawners found.");
        }
        this.buildVanillaSpawners(world, random, spawnerCoords);
        this.buildOneTimeSpawners(world, random, proximityCoords, new Quantity(1.0, 2.0), 5.0);
        result.setData((TemplateGeneratorData)((GeneratorResult)genResult).getData());
        return result.success();
    }
}

