/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.generator.well;

import com.someguyssoftware.gottschcore.cube.Cube;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.config.IWellConfig;
import com.someguyssoftware.treasure2.generator.IGeneratorResult;
import com.someguyssoftware.treasure2.world.gen.structure.TemplateHolder;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public interface IWellGenerator<RESULT extends IGeneratorResult<?>> {
    public RESULT generate(World var1, Random var2, ICoords var3, IWellConfig var4);

    public RESULT generate(World var1, Random var2, ICoords var3, TemplateHolder var4, IWellConfig var5);

    default public void addDecoration(World world, Random random, ICoords coords) {
        Coords[] circle = new Coords[]{coords.add(-2, 0, -2), coords.add(-1, 0, -2), coords.add(0, 0, -2), coords.add(1, 0, -2), coords.add(2, 0, -2), coords.add(-2, 0, -1), coords.add(2, 0, -1), coords.add(-2, 0, 0), coords.add(2, 0, 0), coords.add(-2, 0, 1), coords.add(2, 0, 1), coords.add(-2, 0, 2), coords.add(-1, 0, 2), coords.add(0, 0, 2), coords.add(1, 0, 2), coords.add(2, 0, 2)};
        IBlockState blockState = null;
        for (int i = 0; i < 16; ++i) {
            if (random.nextInt(2) != 0) continue;
            ICoords markerCoords = WorldInfo.getDryLandSurfaceCoords(world, circle[i]);
            if (markerCoords == null || markerCoords == WorldInfo.EMPTY_COORDS) {
                Treasure.logger.debug("Returning due to marker coords == null or EMPTY_COORDS");
                continue;
            }
            Cube markerCube = new Cube(world, markerCoords.add(0, -1, 0));
            if (markerCube.equalsBlock((Block)Blocks.field_150349_c)) {
                blockState = this.getDecorationBlockState(world, (Block)Blocks.field_150328_O);
            } else if (markerCube.equalsBlock(Blocks.field_150346_d)) {
                BlockDirt.DirtType dirtType = (BlockDirt.DirtType)markerCube.getState().func_177229_b((IProperty)BlockDirt.field_176386_a);
                if (dirtType == BlockDirt.DirtType.DIRT) {
                    blockState = this.getDecorationBlockState(world, (Block)Blocks.field_150328_O);
                } else if (dirtType == BlockDirt.DirtType.PODZOL) {
                    BlockBush mushBlock = random.nextInt(2) == 0 ? Blocks.field_150338_P : Blocks.field_150337_Q;
                    blockState = this.getDecorationBlockState(world, (Block)mushBlock);
                } else {
                    blockState = this.getDecorationBlockState(world, (Block)Blocks.field_150329_H);
                }
            } else if (markerCube.equalsBlock((Block)Blocks.field_150391_bh)) {
                Block mushBlock = random.nextInt(2) == 0 ? Blocks.field_150420_aW : Blocks.field_150337_Q;
                blockState = this.getDecorationBlockState(world, mushBlock);
            } else {
                blockState = this.getDecorationBlockState(world, (Block)Blocks.field_150329_H);
            }
            world.func_180501_a(circle[i].toPos(), blockState, 3);
        }
    }

    default public IBlockState getDecorationBlockState(World world, Block block) {
        Random random = new Random();
        if (block == Blocks.field_150328_O) {
            return this.getRedFlowerBlockState(world, random, block);
        }
        if (block == Blocks.field_150338_P || block == Blocks.field_150337_Q) {
            return this.getMushroomBlockState(world, random, block);
        }
        if (block == Blocks.field_150329_H) {
            return this.getGrassBlockState(world, random, block);
        }
        return block.func_176223_P();
    }

    default public IBlockState getRedFlowerBlockState(World world, Random random, Block block) {
        int meta = random.nextInt(8) + 1;
        IBlockState blockState = block.func_176223_P().func_177226_a(((BlockFlower)block).func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.values()[meta]);
        return blockState;
    }

    default public IBlockState getMushroomBlockState(World world, Random random, Block block) {
        return block.func_176223_P();
    }

    default public IBlockState getGrassBlockState(World world, Random random, Block block) {
        int meta = random.nextInt(3);
        return block.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.values()[meta]);
    }
}

