/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.inventory;

import com.someguyssoftware.treasure2.Treasure;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class KeyRingInventory
implements IInventory {
    private ItemStack itemStack;
    private int numberOfSlots = 14;
    private NonNullList<ItemStack> items = NonNullList.func_191197_a((int)this.numberOfSlots, (Object)ItemStack.field_190927_a);

    public KeyRingInventory(ItemStack stack) {
        this.itemStack = stack;
        if (stack.func_77942_o()) {
            this.readInventoryFromNBT(stack.func_77978_p());
        }
    }

    public void readInventoryFromNBT(NBTTagCompound parentNBT) {
        try {
            ItemStackHelper.func_191283_b((NBTTagCompound)parentNBT, this.getItems());
        }
        catch (Exception e) {
            Treasure.logger.error("Error reading Properties from NBT:", (Throwable)e);
        }
    }

    public NBTTagCompound writeInventoryToNBT(NBTTagCompound parentNBT) {
        try {
            ItemStackHelper.func_191282_a((NBTTagCompound)parentNBT, this.getItems());
        }
        catch (Exception e) {
            Treasure.logger.error("Error writing Inventory to NBT:", (Throwable)e);
        }
        return parentNBT;
    }

    public String func_70005_c_() {
        return "display.key_ring.name";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_70302_i_() {
        return this.getNumberOfSlots();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.getItems()) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.getItems().get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.getItems(), (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.getItems(), (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.getItems().set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
        if (this.getItemStack().func_77978_p() == null) {
            return;
        }
        this.getItemStack().func_77978_p().func_74782_a("Items", (NBTBase)new NBTTagList());
        this.getItemStack().func_77978_p().func_74757_a("isOpen", true);
    }

    public void func_174886_c(EntityPlayer player) {
        if (!this.getItemStack().func_77942_o()) {
            this.getItemStack().func_77982_d(new NBTTagCompound());
        }
        this.writeInventoryToNBT(this.getItemStack().func_77978_p());
        this.getItemStack().func_77978_p().func_74757_a("isOpen", false);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.getItems().clear();
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public int getNumberOfSlots() {
        return this.numberOfSlots;
    }

    public void setNumberOfSlots(int numberOfSlots) {
        this.numberOfSlots = numberOfSlots;
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }
}

